/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin;

import com.destroystokyo.paper.event.executor.MethodHandleEventExecutor;
import com.destroystokyo.paper.event.executor.StaticMethodHandleEventExecutor;
import com.destroystokyo.paper.event.executor.asm.ASMEventExecutorGenerator;
import com.destroystokyo.paper.event.executor.asm.ClassDefiner;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public interface EventExecutor {
    public static final ConcurrentMap<Method, Class<? extends EventExecutor>> eventExecutorMap = new ConcurrentHashMap<Method, Class<? extends EventExecutor>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Class<? extends EventExecutor> computeIfAbsent(@NotNull Method key, @NotNull Function<? super Method, ? extends Class<? extends EventExecutor>> mappingFunction) {
            Class executorClass = (Class)this.get(key);
            if (executorClass != null) {
                return executorClass;
            }
            Method method = key;
            synchronized (method) {
                executorClass = (Class)this.get(key);
                if (executorClass != null) {
                    return executorClass;
                }
                return super.computeIfAbsent(key, mappingFunction);
            }
        }
    };

    public void execute(@NotNull Listener var1, @NotNull Event var2) throws EventException;

    @NotNull
    public static EventExecutor create(@NotNull Method m, @NotNull Class<? extends Event> eventClass) {
        Preconditions.checkNotNull((Object)m, (Object)"Null method");
        Preconditions.checkArgument((m.getParameterCount() != 0 ? 1 : 0) != 0, (String)"Incorrect number of arguments %s", (int)m.getParameterCount());
        Preconditions.checkArgument((m.getParameterTypes()[0] == eventClass ? 1 : 0) != 0, (String)"First parameter %s doesn't match event class %s", m.getParameterTypes()[0], eventClass);
        ClassDefiner definer = ClassDefiner.getInstance();
        if (Modifier.isStatic(m.getModifiers())) {
            return new StaticMethodHandleEventExecutor(eventClass, m);
        }
        if (definer.isBypassAccessChecks() || Modifier.isPublic(m.getDeclaringClass().getModifiers()) && Modifier.isPublic(m.getModifiers())) {
            Class executorClass = eventExecutorMap.computeIfAbsent(m, __ -> {
                String name = ASMEventExecutorGenerator.generateName();
                byte[] classData = ASMEventExecutorGenerator.generateEventExecutor(m, name);
                return definer.defineClass(m.getDeclaringClass().getClassLoader(), name, classData).asSubclass(EventExecutor.class);
            });
            try {
                EventExecutor asmExecutor = (EventExecutor)executorClass.newInstance();
                return (listener, event) -> {
                    if (!eventClass.isInstance(event)) {
                        return;
                    }
                    asmExecutor.execute(listener, event);
                };
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AssertionError("Unable to initialize generated event executor", e);
            }
        }
        return new MethodHandleEventExecutor(eventClass, m);
    }
}

