/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerArmorChangeEvent
extends PlayerEvent {
    private static final HandlerList HANDLERS = new HandlerList();
    @NotNull
    private final SlotType slotType;
    @Nullable
    private final ItemStack oldItem;
    @Nullable
    private final ItemStack newItem;

    public PlayerArmorChangeEvent(@NotNull Player player, @NotNull SlotType slotType, @Nullable ItemStack oldItem, @Nullable ItemStack newItem) {
        super(player);
        this.slotType = slotType;
        this.oldItem = oldItem;
        this.newItem = newItem;
    }

    @NotNull
    public SlotType getSlotType() {
        return this.slotType;
    }

    @Nullable
    public ItemStack getOldItem() {
        return this.oldItem;
    }

    @Nullable
    public ItemStack getNewItem() {
        return this.newItem;
    }

    public String toString() {
        return "ArmorChangeEvent{player=" + this.player + ", slotType=" + (Object)((Object)this.slotType) + ", oldItem=" + this.oldItem + ", newItem=" + this.newItem + '}';
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public static enum SlotType {
        HEAD(Material.NETHERITE_HELMET, Material.DIAMOND_HELMET, Material.GOLDEN_HELMET, Material.IRON_HELMET, Material.CHAINMAIL_HELMET, Material.LEATHER_HELMET, Material.CARVED_PUMPKIN, Material.PLAYER_HEAD, Material.SKELETON_SKULL, Material.ZOMBIE_HEAD, Material.CREEPER_HEAD, Material.WITHER_SKELETON_SKULL, Material.TURTLE_HELMET),
        CHEST(Material.NETHERITE_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.IRON_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.LEATHER_CHESTPLATE, Material.ELYTRA),
        LEGS(Material.NETHERITE_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.IRON_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.LEATHER_LEGGINGS),
        FEET(Material.NETHERITE_BOOTS, Material.DIAMOND_BOOTS, Material.GOLDEN_BOOTS, Material.IRON_BOOTS, Material.CHAINMAIL_BOOTS, Material.LEATHER_BOOTS);

        private final Set<Material> mutableTypes = new HashSet<Material>();
        private Set<Material> immutableTypes;

        private SlotType(Material ... types) {
            this.mutableTypes.addAll(Arrays.asList(types));
        }

        @NotNull
        public Set<Material> getTypes() {
            if (this.immutableTypes == null) {
                this.immutableTypes = Collections.unmodifiableSet(this.mutableTypes);
            }
            return this.immutableTypes;
        }

        @Nullable
        public static SlotType getByMaterial(@NotNull Material material) {
            for (SlotType slotType : SlotType.values()) {
                if (!slotType.getTypes().contains(material)) continue;
                return slotType;
            }
            return null;
        }

        public static boolean isEquipable(@NotNull Material material) {
            return SlotType.getByMaterial(material) != null;
        }
    }
}

