/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.destroystokyo.paper.util.VersionFetcher;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class VersionCommand
extends BukkitCommand {
    private VersionFetcher versionFetcher;
    private final ReentrantLock versionLock = new ReentrantLock();
    private boolean hasVersion = false;
    private String versionMessage = null;
    private final Set<CommandSender> versionWaiters = new HashSet<CommandSender>();
    private boolean versionTaskStarted = false;
    private long lastCheck = 0L;

    private VersionFetcher getVersionFetcher() {
        if (this.versionFetcher == null) {
            this.versionFetcher = Bukkit.getUnsafe().getVersionFetcher();
        }
        return this.versionFetcher;
    }

    public VersionCommand(@NotNull String name) {
        super(name);
        this.description = "Gets the version of this server including any plugins in use";
        this.usageMessage = "/version [plugin name]";
        this.setPermission("bukkit.command.version");
        this.setAliases(Arrays.asList("ver", "about"));
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("This server is running " + Bukkit.getName() + " version " + Bukkit.getVersion() + " (Implementing API version " + Bukkit.getBukkitVersion() + ")");
            this.sendVersion(sender);
        } else {
            StringBuilder name = new StringBuilder();
            for (String arg : args) {
                if (name.length() > 0) {
                    name.append(' ');
                }
                name.append(arg);
            }
            String pluginName = name.toString();
            Plugin exactPlugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (exactPlugin != null) {
                this.describeToSender(exactPlugin, sender);
                return true;
            }
            boolean found = false;
            pluginName = pluginName.toLowerCase(Locale.ENGLISH);
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                if (!plugin.getName().toLowerCase(Locale.ENGLISH).contains(pluginName)) continue;
                this.describeToSender(plugin, sender);
                found = true;
            }
            if (!found) {
                sender.sendMessage("This server is not running any plugin by that name.");
                sender.sendMessage("Use /plugins to get a list of plugins.");
            }
        }
        return true;
    }

    private void describeToSender(@NotNull Plugin plugin, @NotNull CommandSender sender) {
        PluginDescriptionFile desc = plugin.getDescription();
        sender.sendMessage((Object)((Object)ChatColor.GREEN) + desc.getName() + (Object)((Object)ChatColor.WHITE) + " version " + (Object)((Object)ChatColor.GREEN) + desc.getVersion());
        if (desc.getDescription() != null) {
            sender.sendMessage(desc.getDescription());
        }
        if (desc.getWebsite() != null) {
            sender.sendMessage("Website: " + (Object)((Object)ChatColor.GREEN) + desc.getWebsite());
        }
        if (!desc.getAuthors().isEmpty()) {
            if (desc.getAuthors().size() == 1) {
                sender.sendMessage("Author: " + this.getNameList(desc.getAuthors()));
            } else {
                sender.sendMessage("Authors: " + this.getNameList(desc.getAuthors()));
            }
        }
        if (!desc.getContributors().isEmpty()) {
            sender.sendMessage("Contributors: " + this.getNameList(desc.getContributors()));
        }
    }

    @NotNull
    private String getNameList(@NotNull List<String> names) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            if (result.length() > 0) {
                result.append((Object)ChatColor.WHITE);
                if (i < names.size() - 1) {
                    result.append(", ");
                } else {
                    result.append(" and ");
                }
            }
            result.append((Object)ChatColor.GREEN);
            result.append(names.get(i));
        }
        return result.toString();
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            String toComplete = args[0].toLowerCase(Locale.ENGLISH);
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                if (!StringUtil.startsWithIgnoreCase(plugin.getName(), toComplete)) continue;
                completions.add(plugin.getName());
            }
            return completions;
        }
        return ImmutableList.of();
    }

    private void sendVersion(@NotNull CommandSender sender) {
        if (this.hasVersion) {
            if (System.currentTimeMillis() - this.lastCheck > this.getVersionFetcher().getCacheTime()) {
                this.lastCheck = System.currentTimeMillis();
                this.hasVersion = false;
            } else {
                this.sendMessages(this.versionMessage, sender);
                return;
            }
        }
        this.versionLock.lock();
        try {
            if (this.hasVersion) {
                this.sendMessages(this.versionMessage, sender);
                return;
            }
            this.versionWaiters.add(sender);
            sender.sendMessage("Checking version, please wait...");
            if (!this.versionTaskStarted) {
                this.versionTaskStarted = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        VersionCommand.this.obtainVersion();
                    }
                }).start();
            }
        }
        finally {
            this.versionLock.unlock();
        }
    }

    private void obtainVersion() {
        String version = Bukkit.getVersion();
        if (version.startsWith("null")) {
            this.setVersionMessage("Unknown version, custom build?");
            return;
        }
        this.setVersionMessage(this.getVersionFetcher().getVersionMessage(version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVersionMessage(@NotNull String msg) {
        this.lastCheck = System.currentTimeMillis();
        this.versionMessage = msg;
        this.versionLock.lock();
        try {
            this.hasVersion = true;
            this.versionTaskStarted = false;
            String[] messages = this.versionMessage.split("\n");
            for (CommandSender sender : this.versionWaiters) {
                for (String message : messages) {
                    sender.sendMessage(message);
                }
            }
            this.versionWaiters.clear();
        }
        finally {
            this.versionLock.unlock();
        }
    }

    private void sendMessages(String toSplit, CommandSender target) {
        String[] messages;
        for (String message : messages = toSplit.split("\n")) {
            target.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getDistance(@NotNull String repo, @NotNull String hash) {
        int n;
        BufferedReader reader = Resources.asCharSource((URL)new URL("https://hub.spigotmc.org/stash/rest/api/1.0/projects/SPIGOT/repos/" + repo + "/commits?since=" + URLEncoder.encode(hash, "UTF-8") + "&withCounts=true"), (Charset)Charsets.UTF_8).openBufferedStream();
        try {
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            n = obj.get("totalCount").getAsInt();
        }
        catch (JsonSyntaxException ex) {
            int n2;
            try {
                ex.printStackTrace();
                n2 = -1;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            reader.close();
            return n2;
        }
        reader.close();
        return n;
    }
}

