/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum WorldType {
    NORMAL("DEFAULT"),
    FLAT("FLAT"),
    VERSION_1_1("DEFAULT_1_1"),
    LARGE_BIOMES("LARGEBIOMES"),
    AMPLIFIED("AMPLIFIED"),
    CUSTOMIZED("CUSTOMIZED"),
    BUFFET("BUFFET");

    private static final Map<String, WorldType> BY_NAME;
    private final String name;

    private WorldType(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static WorldType getByName(@NotNull String name) {
        return BY_NAME.get(name.toUpperCase(Locale.ENGLISH));
    }

    static {
        BY_NAME = Maps.newHashMap();
        for (WorldType type : WorldType.values()) {
            BY_NAME.put(type.name, type);
        }
    }
}

