/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlayerProfile {
    @Nullable
    public String getName();

    @NotNull
    public String setName(@Nullable String var1);

    @Nullable
    public UUID getId();

    @Nullable
    public UUID setId(@Nullable UUID var1);

    @NotNull
    public Set<ProfileProperty> getProperties();

    public boolean hasProperty(@Nullable String var1);

    public void setProperty(@NotNull ProfileProperty var1);

    public void setProperties(@NotNull Collection<ProfileProperty> var1);

    public boolean removeProperty(@Nullable String var1);

    default public boolean removeProperty(@NotNull ProfileProperty property) {
        return this.removeProperty(property.getName());
    }

    default public boolean removeProperties(@NotNull Collection<ProfileProperty> properties) {
        boolean removed = false;
        for (ProfileProperty property : properties) {
            if (!this.removeProperty(property)) continue;
            removed = true;
        }
        return removed;
    }

    public void clearProperties();

    public boolean isComplete();

    public boolean completeFromCache();

    default public boolean complete() {
        return this.complete(true);
    }

    public boolean complete(boolean var1);

    default public boolean hasTextures() {
        return this.hasProperty("textures");
    }
}

