/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialSetTag
implements Tag<Material> {
    private final NamespacedKey key;
    private final Set<Material> materials;

    @Deprecated
    public MaterialSetTag(@NotNull Predicate<Material> filter) {
        this(null, Stream.of(Material.values()).filter(filter).collect(Collectors.toList()));
    }

    @Deprecated
    public MaterialSetTag(@NotNull Collection<Material> materials) {
        this(null, materials);
    }

    @Deprecated
    public MaterialSetTag(Material ... materials) {
        this((NamespacedKey)null, materials);
    }

    public MaterialSetTag(@Nullable NamespacedKey key, @NotNull Predicate<Material> filter) {
        this(key, Stream.of(Material.values()).filter(filter).collect(Collectors.toList()));
    }

    public MaterialSetTag(@Nullable NamespacedKey key, Material ... materials) {
        this(key, Lists.newArrayList((Object[])materials));
    }

    public MaterialSetTag(@Nullable NamespacedKey key, @NotNull Collection<Material> materials) {
        this.key = key != null ? key : NamespacedKey.randomKey();
        this.materials = Sets.newEnumSet(materials, Material.class);
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public MaterialSetTag add(Tag<Material> ... tags) {
        for (Tag<Material> tag : tags) {
            this.add(tag.getValues());
        }
        return this;
    }

    @NotNull
    public MaterialSetTag add(MaterialSetTag ... tags) {
        for (MaterialSetTag tag : tags) {
            this.add(tag.getValues());
        }
        return this;
    }

    @NotNull
    public MaterialSetTag add(Material ... material) {
        this.materials.addAll(Lists.newArrayList((Object[])material));
        return this;
    }

    @NotNull
    public MaterialSetTag add(@NotNull Collection<Material> materials) {
        this.materials.addAll(materials);
        return this;
    }

    @NotNull
    public MaterialSetTag contains(@NotNull String with) {
        return this.add((Material mat) -> mat.name().contains(with));
    }

    @NotNull
    public MaterialSetTag endsWith(@NotNull String with) {
        return this.add((Material mat) -> mat.name().endsWith(with));
    }

    @NotNull
    public MaterialSetTag startsWith(@NotNull String with) {
        return this.add((Material mat) -> mat.name().startsWith(with));
    }

    @NotNull
    public MaterialSetTag add(@NotNull Predicate<Material> filter) {
        this.add(Stream.of(Material.values()).filter(((Predicate<Material>)Material::isLegacy).negate()).filter(filter).collect(Collectors.toList()));
        return this;
    }

    @NotNull
    public MaterialSetTag not(@NotNull MaterialSetTag tags) {
        this.not(tags.getValues());
        return this;
    }

    @NotNull
    public MaterialSetTag not(Material ... material) {
        this.materials.removeAll(Lists.newArrayList((Object[])material));
        return this;
    }

    @NotNull
    public MaterialSetTag not(@NotNull Collection<Material> materials) {
        this.materials.removeAll(materials);
        return this;
    }

    @NotNull
    public MaterialSetTag not(@NotNull Predicate<Material> filter) {
        this.not(Stream.of(Material.values()).filter(((Predicate<Material>)Material::isLegacy).negate()).filter(filter).collect(Collectors.toList()));
        return this;
    }

    @NotNull
    public MaterialSetTag notEndsWith(@NotNull String with) {
        return this.not((Material mat) -> mat.name().endsWith(with));
    }

    @NotNull
    public MaterialSetTag notStartsWith(@NotNull String with) {
        return this.not((Material mat) -> mat.name().startsWith(with));
    }

    @Override
    @NotNull
    public Set<Material> getValues() {
        return this.materials;
    }

    @Override
    public boolean isTagged(@NotNull BlockData block) {
        return this.isTagged(block.getMaterial());
    }

    @Override
    public boolean isTagged(@NotNull BlockState block) {
        return this.isTagged(block.getType());
    }

    @Override
    public boolean isTagged(@NotNull Block block) {
        return this.isTagged(block.getType());
    }

    @Override
    public boolean isTagged(@NotNull ItemStack item) {
        return this.isTagged(item.getType());
    }

    @Override
    public boolean isTagged(@NotNull Material material) {
        return this.materials.contains(material);
    }

    @NotNull
    public MaterialSetTag ensureSize(@NotNull String label, int size) {
        long actual = this.materials.stream().filter(((Predicate<Material>)Material::isLegacy).negate()).count();
        if ((long)size != actual) {
            throw new IllegalStateException(label + " - Expected " + size + " materials, got " + actual);
        }
        return this;
    }
}

