/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.Namespaced;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class NamespacedTag
implements Namespaced {
    public static final String MINECRAFT = "minecraft";
    public static final String BUKKIT = "bukkit";
    private static final Pattern VALID_NAMESPACE = Pattern.compile("[a-z0-9._-]+");
    private static final Pattern VALID_KEY = Pattern.compile("[a-z0-9/._-]+");
    private final String namespace;
    private final String key;

    @Deprecated
    public NamespacedTag(@NotNull String namespace, @NotNull String key) {
        Preconditions.checkArgument((namespace != null && VALID_NAMESPACE.matcher(namespace).matches() ? 1 : 0) != 0, (String)"Invalid namespace. Must be [a-z0-9._-]: %s", (Object)namespace);
        Preconditions.checkArgument((key != null && VALID_KEY.matcher(key).matches() ? 1 : 0) != 0, (String)"Invalid key. Must be [a-z0-9/._-]: %s", (Object)key);
        this.namespace = namespace;
        this.key = key;
        String string = this.toString();
        Preconditions.checkArgument((string.length() < 256 ? 1 : 0) != 0, (String)"NamespacedTag must be less than 256 characters", (Object)string);
    }

    public NamespacedTag(@NotNull Plugin plugin, @NotNull String key) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        this.namespace = plugin.getName().toLowerCase(Locale.ROOT);
        this.key = key.toLowerCase().toLowerCase(Locale.ROOT);
        Preconditions.checkArgument((boolean)VALID_NAMESPACE.matcher(this.namespace).matches(), (String)"Invalid namespace. Must be [a-z0-9._-]: %s", (Object)this.namespace);
        Preconditions.checkArgument((boolean)VALID_KEY.matcher(this.key).matches(), (String)"Invalid key. Must be [a-z0-9/._-]: %s", (Object)this.key);
        String string = this.toString();
        Preconditions.checkArgument((string.length() < 256 ? 1 : 0) != 0, (String)"NamespacedTag must be less than 256 characters (%s)", (Object)string);
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.namespace.hashCode();
        hash = 47 * hash + this.key.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespacedTag other = (NamespacedTag)obj;
        return this.namespace.equals(other.namespace) && this.key.equals(other.key);
    }

    public String toString() {
        return "#" + this.namespace + ":" + this.key;
    }

    @Deprecated
    public static NamespacedTag randomKey() {
        return new NamespacedTag(BUKKIT, UUID.randomUUID().toString());
    }

    @NotNull
    public static NamespacedTag minecraft(@NotNull String key) {
        return new NamespacedTag(MINECRAFT, key);
    }
}

