/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.destroystokyo.paper.block.TargetBlockInfo;
import com.destroystokyo.paper.entity.TargetEntityInfo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attributable;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public interface LivingEntity
extends Attributable,
Entity,
Damageable,
ProjectileSource {
    public double getEyeHeight();

    public double getEyeHeight(boolean var1);

    public Location getEyeLocation();

    public List<Block> getLineOfSight(Set<Material> var1, int var2);

    public Block getTargetBlock(Set<Material> var1, int var2);

    @Nullable
    default public Block getTargetBlock(int maxDistance) {
        return this.getTargetBlock(maxDistance, TargetBlockInfo.FluidMode.NEVER);
    }

    @Nullable
    public Block getTargetBlock(int var1, TargetBlockInfo.FluidMode var2);

    @Nullable
    default public BlockFace getTargetBlockFace(int maxDistance) {
        return this.getTargetBlockFace(maxDistance, TargetBlockInfo.FluidMode.NEVER);
    }

    @Nullable
    public BlockFace getTargetBlockFace(int var1, TargetBlockInfo.FluidMode var2);

    @Nullable
    default public TargetBlockInfo getTargetBlockInfo(int maxDistance) {
        return this.getTargetBlockInfo(maxDistance, TargetBlockInfo.FluidMode.NEVER);
    }

    @Nullable
    public TargetBlockInfo getTargetBlockInfo(int var1, TargetBlockInfo.FluidMode var2);

    @Nullable
    default public Entity getTargetEntity(int maxDistance) {
        return this.getTargetEntity(maxDistance, false);
    }

    @Nullable
    public Entity getTargetEntity(int var1, boolean var2);

    @Nullable
    default public TargetEntityInfo getTargetEntityInfo(int maxDistance) {
        return this.getTargetEntityInfo(maxDistance, false);
    }

    @Nullable
    public TargetEntityInfo getTargetEntityInfo(int var1, boolean var2);

    public List<Block> getLastTwoTargetBlocks(Set<Material> var1, int var2);

    public int getRemainingAir();

    public void setRemainingAir(int var1);

    public int getMaximumAir();

    public void setMaximumAir(int var1);

    public int getMaximumNoDamageTicks();

    public void setMaximumNoDamageTicks(int var1);

    public double getLastDamage();

    public void setLastDamage(double var1);

    public int getNoDamageTicks();

    public void setNoDamageTicks(int var1);

    public Player getKiller();

    public void setKiller(@Nullable Player var1);

    public boolean addPotionEffect(PotionEffect var1);

    public boolean addPotionEffect(PotionEffect var1, boolean var2);

    public boolean addPotionEffects(Collection<PotionEffect> var1);

    public boolean hasPotionEffect(PotionEffectType var1);

    public PotionEffect getPotionEffect(PotionEffectType var1);

    public void removePotionEffect(PotionEffectType var1);

    public Collection<PotionEffect> getActivePotionEffects();

    public boolean hasLineOfSight(Entity var1);

    public boolean getRemoveWhenFarAway();

    public void setRemoveWhenFarAway(boolean var1);

    public EntityEquipment getEquipment();

    public void setCanPickupItems(boolean var1);

    public boolean getCanPickupItems();

    public boolean isLeashed();

    public Entity getLeashHolder() throws IllegalStateException;

    public boolean setLeashHolder(Entity var1);

    public boolean isGliding();

    public void setGliding(boolean var1);

    public boolean isSwimming();

    public void setSwimming(boolean var1);

    public boolean isRiptiding();

    public void setAI(boolean var1);

    public boolean hasAI();

    public void setCollidable(boolean var1);

    public boolean isCollidable();

    public int getArrowsStuck();

    public void setArrowsStuck(int var1);

    public int getShieldBlockingDelay();

    public void setShieldBlockingDelay(int var1);

    public ItemStack getActiveItem();

    public int getItemUseRemainingTime();

    public int getHandRaisedTime();

    public boolean isHandRaised();
}

