/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.material.MaterialData;

public class ShapelessRecipe
implements Recipe,
Keyed {
    private final NamespacedKey key;
    private final ItemStack output;
    private final List<RecipeChoice> ingredients = new ArrayList<RecipeChoice>();
    private String group = "";

    @Deprecated
    public ShapelessRecipe(ItemStack result) {
        this.key = NamespacedKey.randomKey();
        new Throwable("Warning: A plugin is creating a recipe using a Deprecated method. This will cause you to receive warnings stating 'Tried to load unrecognized recipe: bukkit:<ID>'. Please ask the author to give their recipe a static key using NamespacedKey.").printStackTrace();
        this.output = new ItemStack(result);
    }

    public ShapelessRecipe(NamespacedKey key, ItemStack result) {
        this.key = key;
        this.output = new ItemStack(result);
    }

    public ShapelessRecipe addIngredient(MaterialData ingredient) {
        return this.addIngredient(1, ingredient);
    }

    public ShapelessRecipe addIngredient(Material ingredient) {
        return this.addIngredient(1, ingredient, 0);
    }

    @Deprecated
    public ShapelessRecipe addIngredient(Material ingredient, int rawdata) {
        return this.addIngredient(1, ingredient, rawdata);
    }

    public ShapelessRecipe addIngredient(int count, MaterialData ingredient) {
        return this.addIngredient(count, ingredient.getItemType(), ingredient.getData());
    }

    public ShapelessRecipe addIngredient(int count, Material ingredient) {
        return this.addIngredient(count, ingredient, 0);
    }

    @Deprecated
    public ShapelessRecipe addIngredient(int count, Material ingredient, int rawdata) {
        Validate.isTrue((this.ingredients.size() + count <= 9 ? 1 : 0) != 0, (String)"Shapeless recipes cannot have more than 9 ingredients");
        if (rawdata == -1) {
            rawdata = Short.MAX_VALUE;
        }
        while (count-- > 0) {
            this.ingredients.add(new RecipeChoice.MaterialChoice(Collections.singletonList(ingredient)));
        }
        return this;
    }

    public ShapelessRecipe addIngredient(RecipeChoice ingredient) {
        Validate.isTrue((this.ingredients.size() + 1 <= 9 ? 1 : 0) != 0, (String)"Shapeless recipes cannot have more than 9 ingredients");
        this.ingredients.add(ingredient);
        return this;
    }

    public ShapelessRecipe removeIngredient(RecipeChoice ingredient) {
        this.ingredients.remove(ingredient);
        return this;
    }

    public ShapelessRecipe removeIngredient(Material ingredient) {
        return this.removeIngredient(ingredient, 0);
    }

    public ShapelessRecipe removeIngredient(MaterialData ingredient) {
        return this.removeIngredient(ingredient.getItemType(), ingredient.getData());
    }

    public ShapelessRecipe removeIngredient(int count, Material ingredient) {
        return this.removeIngredient(count, ingredient, 0);
    }

    public ShapelessRecipe removeIngredient(int count, MaterialData ingredient) {
        return this.removeIngredient(count, ingredient.getItemType(), ingredient.getData());
    }

    @Deprecated
    public ShapelessRecipe removeIngredient(Material ingredient, int rawdata) {
        return this.removeIngredient(1, ingredient, rawdata);
    }

    @Deprecated
    public ShapelessRecipe removeIngredient(int count, Material ingredient, int rawdata) {
        Iterator<RecipeChoice> iterator = this.ingredients.iterator();
        while (count > 0 && iterator.hasNext()) {
            ItemStack stack = iterator.next().getItemStack();
            if (stack.getType() != ingredient || stack.getDurability() != rawdata) continue;
            iterator.remove();
            --count;
        }
        return this;
    }

    @Override
    public ItemStack getResult() {
        return this.output.clone();
    }

    public List<ItemStack> getIngredientList() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(this.ingredients.size());
        for (RecipeChoice ingredient : this.ingredients) {
            result.add(ingredient.getItemStack().clone());
        }
        return result;
    }

    public List<RecipeChoice> getChoiceList() {
        ArrayList<RecipeChoice> result = new ArrayList<RecipeChoice>(this.ingredients.size());
        for (RecipeChoice ingredient : this.ingredients) {
            result.add(ingredient.clone());
        }
        return result;
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)"group");
        this.group = group;
    }
}

