/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.entity;

import org.bukkit.Location;
import org.bukkit.entity.Turtle;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;

public class TurtleLayEggEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled = false;
    private final Location location;
    private int eggCount;

    public TurtleLayEggEvent(Turtle turtle, Location location, int eggCount) {
        super(turtle);
        this.location = location;
        this.eggCount = eggCount;
    }

    @Override
    public Turtle getEntity() {
        return (Turtle)this.entity;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getEggCount() {
        return this.eggCount;
    }

    public void setEggCount(int eggCount) {
        if (eggCount < 1) {
            this.cancelled = true;
            return;
        }
        eggCount = Math.min(eggCount, 4);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

