/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.NumberConversions;

public class ParticleBuilder {
    private Particle particle;
    private List<Player> receivers;
    private Player source;
    private Location location;
    private int count = 1;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double offsetZ = 0.0;
    private double extra = 1.0;
    private Object data;
    private boolean force = true;

    public ParticleBuilder(Particle particle) {
        this.particle = particle;
    }

    public ParticleBuilder spawn() {
        if (this.location == null) {
            throw new IllegalStateException("Please specify location for this particle");
        }
        this.location.getWorld().spawnParticle(this.particle, this.receivers, this.source, this.location.getX(), this.location.getY(), this.location.getZ(), this.count, this.offsetX, this.offsetY, this.offsetZ, this.extra, this.data, this.force);
        return this;
    }

    public Particle particle() {
        return this.particle;
    }

    public ParticleBuilder particle(Particle particle) {
        this.particle = particle;
        return this;
    }

    @Nullable
    public List<Player> receivers() {
        return this.receivers;
    }

    public boolean hasReceivers() {
        return this.receivers == null && !this.location.getWorld().getPlayers().isEmpty() || this.receivers != null && !this.receivers.isEmpty();
    }

    public ParticleBuilder allPlayers() {
        this.receivers = null;
        return this;
    }

    public ParticleBuilder receivers(@Nullable List<Player> receivers) {
        this.receivers = receivers != null ? Lists.newArrayList(receivers) : null;
        return this;
    }

    public ParticleBuilder receivers(@Nullable Collection<Player> receivers) {
        this.receivers = receivers != null ? Lists.newArrayList(receivers) : null;
        return this;
    }

    public ParticleBuilder receivers(Player ... receivers) {
        this.receivers = receivers != null ? Lists.newArrayList((Object[])receivers) : null;
        return this;
    }

    public ParticleBuilder receivers(int radius) {
        return this.receivers(radius, radius);
    }

    public ParticleBuilder receivers(int radius, boolean byDistance) {
        if (!byDistance) {
            return this.receivers(radius, radius, radius);
        }
        this.receivers = Lists.newArrayList();
        for (Player nearbyPlayer : this.location.getWorld().getNearbyPlayers(this.location, (double)radius, (double)radius, radius)) {
            double z;
            double y;
            Location loc = nearbyPlayer.getLocation();
            double x = NumberConversions.square(this.location.getX() - loc.getX());
            if (Math.sqrt(x + (y = NumberConversions.square(this.location.getY() - loc.getY())) + (z = NumberConversions.square(this.location.getZ() - loc.getZ()))) > (double)radius) continue;
            this.receivers.add(nearbyPlayer);
        }
        return this;
    }

    public ParticleBuilder receivers(int xzRadius, int yRadius) {
        return this.receivers(xzRadius, yRadius, xzRadius);
    }

    public ParticleBuilder receivers(int xzRadius, int yRadius, boolean byDistance) {
        if (!byDistance) {
            return this.receivers(xzRadius, yRadius, xzRadius);
        }
        this.receivers = Lists.newArrayList();
        for (Player nearbyPlayer : this.location.getWorld().getNearbyPlayers(this.location, (double)xzRadius, (double)yRadius, xzRadius)) {
            double z;
            double x;
            Location loc = nearbyPlayer.getLocation();
            if (Math.abs(loc.getY() - this.location.getY()) > (double)yRadius || (x = NumberConversions.square(this.location.getX() - loc.getX())) + (z = NumberConversions.square(this.location.getZ() - loc.getZ())) > NumberConversions.square(xzRadius)) continue;
            this.receivers.add(nearbyPlayer);
        }
        return this;
    }

    public ParticleBuilder receivers(int xRadius, int yRadius, int zRadius) {
        if (this.location == null) {
            throw new IllegalStateException("Please set location first");
        }
        return this.receivers(this.location.getWorld().getNearbyPlayers(this.location, (double)xRadius, (double)yRadius, zRadius));
    }

    public Player source() {
        return this.source;
    }

    public ParticleBuilder source(Player source) {
        this.source = source;
        return this;
    }

    public Location location() {
        return this.location;
    }

    public ParticleBuilder location(Location location) {
        this.location = location.clone();
        return this;
    }

    public ParticleBuilder location(World world, double x, double y, double z) {
        this.location = new Location(world, x, y, z);
        return this;
    }

    public int count() {
        return this.count;
    }

    public ParticleBuilder count(int count) {
        this.count = count;
        return this;
    }

    public double offsetX() {
        return this.offsetX;
    }

    public double offsetY() {
        return this.offsetY;
    }

    public double offsetZ() {
        return this.offsetZ;
    }

    public ParticleBuilder offset(double offsetX, double offsetY, double offsetZ) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        return this;
    }

    public double extra() {
        return this.extra;
    }

    public ParticleBuilder extra(double extra) {
        this.extra = extra;
        return this;
    }

    public <T> T data() {
        return (T)this.data;
    }

    public <T> ParticleBuilder data(T data) {
        this.data = data;
        return this;
    }

    public ParticleBuilder force(boolean force) {
        this.force = force;
        return this;
    }

    public ParticleBuilder color(Color color) {
        return this.color(color, 1.0f);
    }

    public ParticleBuilder color(Color color, float size) {
        if (this.particle != Particle.REDSTONE) {
            throw new IllegalStateException("Color may only be set on REDSTONE");
        }
        return this.data(new Particle.DustOptions(color, size));
    }

    public ParticleBuilder color(int r, int g, int b) {
        return this.color(Color.fromRGB(r, g, b));
    }
}

