/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.attribute;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.NumberConversions;

public class AttributeModifier
implements ConfigurationSerializable {
    private final UUID uuid;
    private final String name;
    private final double amount;
    private final Operation operation;
    private final EquipmentSlot slot;

    public AttributeModifier(String name, double amount, Operation operation) {
        this(UUID.randomUUID(), name, amount, operation);
    }

    public AttributeModifier(UUID uuid, String name, double amount, Operation operation) {
        this(uuid, name, amount, operation, null);
    }

    public AttributeModifier(UUID uuid, String name, double amount, Operation operation, EquipmentSlot slot) {
        Validate.notNull((Object)uuid, (String)"UUID cannot be null");
        Validate.notNull((Object)((Object)operation), (String)"Operation cannot be null");
        this.uuid = uuid;
        this.name = name != null ? name : "";
        this.amount = amount;
        this.operation = operation;
        this.slot = slot;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public double getAmount() {
        return this.amount;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public EquipmentSlot getSlot() {
        return this.slot;
    }

    @Override
    public Map<String, Object> serialize() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("uuid", this.uuid.toString());
        data.put("name", this.name);
        data.put("operation", this.operation.ordinal());
        data.put("amount", this.amount);
        if (this.slot != null) {
            data.put("slot", this.slot.name());
        }
        return data;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AttributeModifier)) {
            return false;
        }
        AttributeModifier mod = (AttributeModifier)other;
        boolean slots = this.slot != null ? this.slot == mod.slot : mod.slot != null;
        return this.uuid.equals(mod.uuid) && this.name.equals(mod.name) && this.amount == mod.amount && this.operation == mod.operation && slots;
    }

    public String toString() {
        return "AttributeModifier{uuid=" + this.uuid.toString() + ", name=" + this.name + ", operation=" + this.operation.name() + ", amount=" + this.amount + ", slot=" + (this.slot != null ? this.slot.name() : "") + "}";
    }

    public static AttributeModifier deserialize(Map<String, Object> args) {
        if (args.containsKey("slot")) {
            return new AttributeModifier(UUID.fromString((String)args.get("uuid")), (String)args.get("name"), NumberConversions.toDouble(args.get("amount")), Operation.values()[NumberConversions.toInt(args.get("operation"))], EquipmentSlot.valueOf(args.get("slot").toString().toUpperCase()));
        }
        return new AttributeModifier(UUID.fromString((String)args.get("uuid")), (String)args.get("name"), NumberConversions.toDouble(args.get("amount")), Operation.values()[NumberConversions.toInt(args.get("operation"))]);
    }

    public static enum Operation {
        ADD_NUMBER,
        ADD_SCALAR,
        MULTIPLY_SCALAR_1;

    }
}

