/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import java.util.List;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.inventory.ItemStack;

public class EntityDeathEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final List<ItemStack> drops;
    private int dropExp = 0;
    private boolean cancelled;
    private double reviveHealth = 0.0;
    private boolean shouldPlayDeathSound;
    private Sound deathSound;
    private SoundCategory deathSoundCategory;
    private float deathSoundVolume;
    private float deathSoundPitch;

    public EntityDeathEvent(LivingEntity entity, List<ItemStack> drops) {
        this(entity, drops, 0);
    }

    public EntityDeathEvent(LivingEntity what, List<ItemStack> drops, int droppedExp) {
        super(what);
        this.drops = drops;
        this.dropExp = droppedExp;
    }

    @Override
    public LivingEntity getEntity() {
        return (LivingEntity)this.entity;
    }

    public int getDroppedExp() {
        return this.dropExp;
    }

    public void setDroppedExp(int exp) {
        this.dropExp = exp;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public double getReviveHealth() {
        return this.reviveHealth;
    }

    public void setReviveHealth(double reviveHealth) throws IllegalArgumentException {
        double maxHealth = ((LivingEntity)this.entity).getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        if (reviveHealth <= 0.0 || reviveHealth > maxHealth) {
            throw new IllegalArgumentException("Health must be between 0 (exclusive) and " + maxHealth + " (inclusive), but was " + reviveHealth);
        }
        this.reviveHealth = reviveHealth;
    }

    public boolean shouldPlayDeathSound() {
        return this.shouldPlayDeathSound;
    }

    public void setShouldPlayDeathSound(boolean playDeathSound) {
        this.shouldPlayDeathSound = playDeathSound;
    }

    public Sound getDeathSound() {
        return this.deathSound;
    }

    public void setDeathSound(Sound sound) {
        this.deathSound = sound;
    }

    public SoundCategory getDeathSoundCategory() {
        return this.deathSoundCategory;
    }

    public void setDeathSoundCategory(SoundCategory soundCategory) {
        this.deathSoundCategory = soundCategory;
    }

    public float getDeathSoundVolume() {
        return this.deathSoundVolume;
    }

    public void setDeathSoundVolume(float volume) {
        this.deathSoundVolume = volume;
    }

    public float getDeathSoundPitch() {
        return this.deathSoundPitch;
    }

    public void setDeathSoundPitch(float pitch) {
        this.deathSoundPitch = pitch;
    }
}

