/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingHandler;
import co.aikar.util.LoadingMap;
import co.aikar.util.MRUMapCache;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

final class TimingIdentifier {
    static final Map<String, TimingGroup> GROUP_MAP = MRUMapCache.of(LoadingMap.newIdentityHashMap(x$0 -> new TimingGroup((String)x$0), 64));
    private static final TimingGroup DEFAULT_GROUP = TimingIdentifier.getGroup("Minecraft");
    final String group;
    final String name;
    final TimingHandler groupHandler;
    private final int hashCode;

    TimingIdentifier(String group, String name, Timing groupHandler) {
        this.group = group != null ? group.intern() : TimingIdentifier.DEFAULT_GROUP.name;
        this.name = name.intern();
        this.groupHandler = groupHandler != null ? groupHandler.getTimingHandler() : null;
        this.hashCode = 31 * this.group.hashCode() + this.name.hashCode();
    }

    static TimingGroup getGroup(String groupName) {
        if (groupName == null) {
            return DEFAULT_GROUP;
        }
        return GROUP_MAP.get(groupName.intern());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        TimingIdentifier that = (TimingIdentifier)o;
        return this.group == that.group && this.name == that.name;
    }

    public int hashCode() {
        return this.hashCode;
    }

    static class TimingGroup {
        private static AtomicInteger idPool = new AtomicInteger(1);
        final int id = idPool.getAndIncrement();
        final String name;
        ArrayDeque<TimingHandler> handlers = new ArrayDeque(64);

        private TimingGroup(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimingGroup that = (TimingGroup)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

