/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.TreeType;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.messaging.PluginMessageRecipient;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;

public interface World
extends PluginMessageRecipient,
Metadatable {
    public int getEntityCount();

    public int getTileEntityCount();

    public int getTickableTileEntityCount();

    public int getChunkCount();

    public int getPlayerCount();

    public Block getBlockAt(int var1, int var2, int var3);

    public Block getBlockAt(Location var1);

    default public Block getBlockAtKey(long key) {
        int x = (int)(key << 37 >> 37);
        int y = (int)(key >>> 54);
        int z = (int)(key << 10 >> 37);
        return this.getBlockAt(x, y, z);
    }

    default public Location getLocationAtKey(long key) {
        int x = (int)(key << 37 >> 37);
        int y = (int)(key >>> 54);
        int z = (int)(key << 10 >> 37);
        return new Location(this, x, y, z);
    }

    public int getHighestBlockYAt(int var1, int var2);

    public int getHighestBlockYAt(Location var1);

    public Block getHighestBlockAt(int var1, int var2);

    public Block getHighestBlockAt(Location var1);

    public Chunk getChunkAt(int var1, int var2);

    public Chunk getChunkAt(Location var1);

    public Chunk getChunkAt(Block var1);

    default public Chunk getChunkAt(long chunkKey) {
        return this.getChunkAt((int)chunkKey, (int)(chunkKey >> 32));
    }

    default public boolean isChunkGenerated(long chunkKey) {
        return this.isChunkGenerated((int)chunkKey, (int)(chunkKey >> 32));
    }

    public boolean isChunkGenerated(int var1, int var2);

    public void getChunkAtAsync(int var1, int var2, ChunkLoadCallback var3);

    public void getChunkAtAsync(Location var1, ChunkLoadCallback var2);

    public void getChunkAtAsync(Block var1, ChunkLoadCallback var2);

    public boolean isChunkLoaded(Chunk var1);

    public Chunk[] getLoadedChunks();

    public void loadChunk(Chunk var1);

    public boolean isChunkLoaded(int var1, int var2);

    public boolean isChunkInUse(int var1, int var2);

    public void loadChunk(int var1, int var2);

    public boolean loadChunk(int var1, int var2, boolean var3);

    public boolean unloadChunk(Chunk var1);

    public boolean unloadChunk(int var1, int var2);

    public boolean unloadChunk(int var1, int var2, boolean var3);

    @Deprecated
    public boolean unloadChunk(int var1, int var2, boolean var3, boolean var4);

    public boolean unloadChunkRequest(int var1, int var2);

    public boolean unloadChunkRequest(int var1, int var2, boolean var3);

    @Deprecated
    public boolean regenerateChunk(int var1, int var2);

    @Deprecated
    public boolean refreshChunk(int var1, int var2);

    public Item dropItem(Location var1, ItemStack var2);

    public Item dropItemNaturally(Location var1, ItemStack var2);

    public Arrow spawnArrow(Location var1, Vector var2, float var3, float var4);

    public <T extends Arrow> T spawnArrow(Location var1, Vector var2, float var3, float var4, Class<T> var5);

    public boolean generateTree(Location var1, TreeType var2);

    public boolean generateTree(Location var1, TreeType var2, BlockChangeDelegate var3);

    public Entity spawnEntity(Location var1, EntityType var2);

    public LightningStrike strikeLightning(Location var1);

    public LightningStrike strikeLightningEffect(Location var1);

    public List<Entity> getEntities();

    public List<LivingEntity> getLivingEntities();

    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... var1);

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> var1);

    public Collection<Entity> getEntitiesByClasses(Class<?> ... var1);

    default public Collection<LivingEntity> getNearbyLivingEntities(Location loc, double radius) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, radius, radius, radius);
    }

    default public Collection<LivingEntity> getNearbyLivingEntities(Location loc, double xzRadius, double yRadius) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xzRadius, yRadius, xzRadius);
    }

    default public Collection<LivingEntity> getNearbyLivingEntities(Location loc, double xRadius, double yRadius, double zRadius) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xRadius, yRadius, zRadius);
    }

    default public Collection<LivingEntity> getNearbyLivingEntities(Location loc, double radius, Predicate<LivingEntity> predicate) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, radius, radius, radius, predicate);
    }

    default public Collection<LivingEntity> getNearbyLivingEntities(Location loc, double xzRadius, double yRadius, Predicate<LivingEntity> predicate) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xzRadius, yRadius, xzRadius, predicate);
    }

    default public Collection<LivingEntity> getNearbyLivingEntities(Location loc, double xRadius, double yRadius, double zRadius, Predicate<LivingEntity> predicate) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xRadius, yRadius, zRadius, predicate);
    }

    default public Collection<Player> getNearbyPlayers(Location loc, double radius) {
        return this.getNearbyEntitiesByType(Player.class, loc, radius, radius, radius);
    }

    default public Collection<Player> getNearbyPlayers(Location loc, double xzRadius, double yRadius) {
        return this.getNearbyEntitiesByType(Player.class, loc, xzRadius, yRadius, xzRadius);
    }

    default public Collection<Player> getNearbyPlayers(Location loc, double xRadius, double yRadius, double zRadius) {
        return this.getNearbyEntitiesByType(Player.class, loc, xRadius, yRadius, zRadius);
    }

    default public Collection<Player> getNearbyPlayers(Location loc, double radius, Predicate<Player> predicate) {
        return this.getNearbyEntitiesByType(Player.class, loc, radius, radius, radius, predicate);
    }

    default public Collection<Player> getNearbyPlayers(Location loc, double xzRadius, double yRadius, Predicate<Player> predicate) {
        return this.getNearbyEntitiesByType(Player.class, loc, xzRadius, yRadius, xzRadius, predicate);
    }

    default public Collection<Player> getNearbyPlayers(Location loc, double xRadius, double yRadius, double zRadius, Predicate<Player> predicate) {
        return this.getNearbyEntitiesByType(Player.class, loc, xRadius, yRadius, zRadius, predicate);
    }

    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(Class<? extends T> clazz, Location loc, double radius) {
        return this.getNearbyEntitiesByType(clazz, loc, radius, radius, radius, null);
    }

    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(Class<? extends T> clazz, Location loc, double xzRadius, double yRadius) {
        return this.getNearbyEntitiesByType(clazz, loc, xzRadius, yRadius, xzRadius, null);
    }

    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(Class<? extends T> clazz, Location loc, double xRadius, double yRadius, double zRadius) {
        return this.getNearbyEntitiesByType(clazz, loc, xRadius, yRadius, zRadius, null);
    }

    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(Class<? extends T> clazz, Location loc, double radius, Predicate<T> predicate) {
        return this.getNearbyEntitiesByType(clazz, loc, radius, radius, radius, predicate);
    }

    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(Class<? extends T> clazz, Location loc, double xzRadius, double yRadius, Predicate<T> predicate) {
        return this.getNearbyEntitiesByType(clazz, loc, xzRadius, yRadius, xzRadius, predicate);
    }

    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(Class<? extends Entity> clazz, Location loc, double xRadius, double yRadius, double zRadius, Predicate<T> predicate) {
        if (clazz == null) {
            clazz = Entity.class;
        }
        ArrayList<Entity> nearby = new ArrayList<Entity>();
        for (Entity bukkitEntity : this.getNearbyEntities(loc, xRadius, yRadius, zRadius)) {
            if (!clazz.isAssignableFrom(bukkitEntity.getClass()) || predicate != null && !predicate.test(bukkitEntity)) continue;
            nearby.add(bukkitEntity);
        }
        return nearby;
    }

    public List<Player> getPlayers();

    public Collection<Entity> getNearbyEntities(Location var1, double var2, double var4, double var6);

    public Entity getEntity(UUID var1);

    public String getName();

    public UUID getUID();

    public Location getSpawnLocation();

    public boolean setSpawnLocation(Location var1);

    public boolean setSpawnLocation(int var1, int var2, int var3);

    public long getTime();

    public void setTime(long var1);

    public long getFullTime();

    public void setFullTime(long var1);

    public boolean hasStorm();

    public void setStorm(boolean var1);

    public int getWeatherDuration();

    public void setWeatherDuration(int var1);

    public boolean isThundering();

    public void setThundering(boolean var1);

    public int getThunderDuration();

    public void setThunderDuration(int var1);

    public boolean createExplosion(double var1, double var3, double var5, float var7);

    public boolean createExplosion(double var1, double var3, double var5, float var7, boolean var8);

    public boolean createExplosion(double var1, double var3, double var5, float var7, boolean var8, boolean var9);

    public boolean createExplosion(Location var1, float var2);

    public boolean createExplosion(Location var1, float var2, boolean var3);

    public boolean createExplosion(Entity var1, Location var2, float var3, boolean var4, boolean var5);

    default public boolean createExplosion(Entity source, Location loc, float power, boolean setFire) {
        return this.createExplosion(source, loc, power, setFire, true);
    }

    default public boolean createExplosion(Entity source, Location loc, float power) {
        return this.createExplosion(source, loc, power, true, true);
    }

    default public boolean createExplosion(Entity source, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(source, source.getLocation(), power, setFire, breakBlocks);
    }

    default public boolean createExplosion(Entity source, float power, boolean setFire) {
        return this.createExplosion(source, source.getLocation(), power, setFire, true);
    }

    default public boolean createExplosion(Entity source, float power) {
        return this.createExplosion(source, source.getLocation(), power, true, true);
    }

    default public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks);
    }

    public Environment getEnvironment();

    public long getSeed();

    public boolean getPVP();

    public void setPVP(boolean var1);

    public ChunkGenerator getGenerator();

    public void save();

    public List<BlockPopulator> getPopulators();

    public <T extends Entity> T spawn(Location var1, Class<T> var2) throws IllegalArgumentException;

    public <T extends Entity> T spawn(Location var1, Class<T> var2, Consumer<T> var3) throws IllegalArgumentException;

    public FallingBlock spawnFallingBlock(Location var1, MaterialData var2) throws IllegalArgumentException;

    public FallingBlock spawnFallingBlock(Location var1, BlockData var2) throws IllegalArgumentException;

    @Deprecated
    public FallingBlock spawnFallingBlock(Location var1, Material var2, byte var3) throws IllegalArgumentException;

    public void playEffect(Location var1, Effect var2, int var3);

    public void playEffect(Location var1, Effect var2, int var3, int var4);

    public <T> void playEffect(Location var1, Effect var2, T var3);

    public <T> void playEffect(Location var1, Effect var2, T var3, int var4);

    public ChunkSnapshot getEmptyChunkSnapshot(int var1, int var2, boolean var3, boolean var4);

    public void setSpawnFlags(boolean var1, boolean var2);

    public boolean getAllowAnimals();

    public boolean getAllowMonsters();

    public Biome getBiome(int var1, int var2);

    public void setBiome(int var1, int var2, Biome var3);

    public double getTemperature(int var1, int var2);

    public double getHumidity(int var1, int var2);

    public int getMaxHeight();

    public int getSeaLevel();

    public boolean getKeepSpawnInMemory();

    public void setKeepSpawnInMemory(boolean var1);

    public boolean isAutoSave();

    public void setAutoSave(boolean var1);

    public void setDifficulty(Difficulty var1);

    public Difficulty getDifficulty();

    public File getWorldFolder();

    public WorldType getWorldType();

    public boolean canGenerateStructures();

    public long getTicksPerAnimalSpawns();

    public void setTicksPerAnimalSpawns(int var1);

    public long getTicksPerMonsterSpawns();

    public void setTicksPerMonsterSpawns(int var1);

    public int getMonsterSpawnLimit();

    public void setMonsterSpawnLimit(int var1);

    public int getAnimalSpawnLimit();

    public void setAnimalSpawnLimit(int var1);

    public int getWaterAnimalSpawnLimit();

    public void setWaterAnimalSpawnLimit(int var1);

    public int getAmbientSpawnLimit();

    public void setAmbientSpawnLimit(int var1);

    public void playSound(Location var1, Sound var2, float var3, float var4);

    public void playSound(Location var1, String var2, float var3, float var4);

    public void playSound(Location var1, Sound var2, SoundCategory var3, float var4, float var5);

    public void playSound(Location var1, String var2, SoundCategory var3, float var4, float var5);

    public String[] getGameRules();

    @Deprecated
    public String getGameRuleValue(String var1);

    @Deprecated
    public boolean setGameRuleValue(String var1, String var2);

    public boolean isGameRule(String var1);

    public <T> T getGameRuleValue(GameRule<T> var1);

    public <T> T getGameRuleDefault(GameRule<T> var1);

    public <T> boolean setGameRule(GameRule<T> var1, T var2);

    public WorldBorder getWorldBorder();

    public void spawnParticle(Particle var1, Location var2, int var3);

    public void spawnParticle(Particle var1, double var2, double var4, double var6, int var8);

    public <T> void spawnParticle(Particle var1, Location var2, int var3, T var4);

    public <T> void spawnParticle(Particle var1, double var2, double var4, double var6, int var8, T var9);

    public void spawnParticle(Particle var1, Location var2, int var3, double var4, double var6, double var8);

    public void spawnParticle(Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13);

    public <T> void spawnParticle(Particle var1, Location var2, int var3, double var4, double var6, double var8, T var10);

    public <T> void spawnParticle(Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, T var15);

    public void spawnParticle(Particle var1, Location var2, int var3, double var4, double var6, double var8, double var10);

    public void spawnParticle(Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15);

    public <T> void spawnParticle(Particle var1, Location var2, int var3, double var4, double var6, double var8, double var10, T var12);

    default public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, null, null, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, true);
    }

    default public <T> void spawnParticle(Particle particle, List<Player> receivers, Player source, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, receivers, source, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, true);
    }

    public <T> void spawnParticle(Particle var1, List<Player> var2, Player var3, double var4, double var6, double var8, int var10, double var11, double var13, double var15, double var17, T var19, boolean var20);

    public Spigot spigot();

    public static enum Environment {
        NORMAL(0),
        NETHER(-1),
        THE_END(1);

        private final int id;
        private static final Map<Integer, Environment> lookup;

        private Environment(int id) {
            this.id = id;
        }

        @Deprecated
        public int getId() {
            return this.id;
        }

        @Deprecated
        public static Environment getEnvironment(int id) {
            return lookup.get(id);
        }

        static {
            lookup = new HashMap<Integer, Environment>();
            for (Environment env : Environment.values()) {
                lookup.put(env.getId(), env);
            }
        }
    }

    public static class Spigot {
        public LightningStrike strikeLightning(Location loc, boolean isSilent) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public LightningStrike strikeLightningEffect(Location loc, boolean isSilent) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static interface ChunkLoadCallback {
        public void onLoad(Chunk var1);
    }
}

