/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public class ItemStack
implements Cloneable,
ConfigurationSerializable {
    private Material type = Material.AIR;
    private int amount = 0;
    private MaterialData data = null;
    private ItemMeta meta;

    protected ItemStack() {
    }

    public ItemStack(Material type) {
        this(type, 1);
    }

    public ItemStack(Material type, int amount) {
        this(type, amount, 0);
    }

    public ItemStack(Material type, int amount, short damage) {
        this(type, amount, damage, null);
    }

    @Deprecated
    public ItemStack(Material type, int amount, short damage, Byte data) {
        Validate.notNull((Object)type, (String)"Material cannot be null");
        this.type = type;
        this.amount = amount;
        if (damage != 0) {
            this.setDurability(damage);
        }
        if (data != null) {
            this.createData(data);
        }
    }

    public ItemStack(ItemStack stack) throws IllegalArgumentException {
        Validate.notNull((Object)stack, (String)"Cannot copy null stack");
        this.type = stack.getType();
        this.amount = stack.getAmount();
        this.data = stack.getData();
        if (stack.hasItemMeta()) {
            this.setItemMeta0(stack.getItemMeta(), this.type);
        }
    }

    public Material getType() {
        return this.type;
    }

    public void setType(Material type) {
        Validate.notNull((Object)type, (String)"Material cannot be null");
        this.type = type;
        if (this.meta != null) {
            this.meta = Bukkit.getItemFactory().asMetaFor(this.meta, type);
        }
        if (type.isLegacy()) {
            this.createData((byte)0);
        }
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public MaterialData getData() {
        Material mat = Bukkit.getUnsafe().toLegacy(this.getType());
        if (this.data == null && mat != null && mat.getData() != null) {
            this.data = mat.getNewData((byte)this.getDurability());
        }
        return this.data;
    }

    public void setData(MaterialData data) {
        Material mat = Bukkit.getUnsafe().toLegacy(this.getType());
        if (data == null || mat == null || mat.getData() == null) {
            this.data = data;
        } else if (data.getClass() == mat.getData() || data.getClass() == MaterialData.class) {
            this.data = data;
        } else {
            throw new IllegalArgumentException("Provided data is not of type " + mat.getData().getName() + ", found " + data.getClass().getName());
        }
    }

    public void setDurability(short durability) {
        ItemMeta meta = this.getItemMeta();
        if (meta != null) {
            ((Damageable)((Object)meta)).setDamage(durability);
            this.setItemMeta(meta);
        }
    }

    public short getDurability() {
        ItemMeta meta = this.getItemMeta();
        return meta == null ? (short)0 : (short)((Damageable)((Object)meta)).getDamage();
    }

    public int getMaxStackSize() {
        Material material = this.getType();
        if (material != null) {
            return material.getMaxStackSize();
        }
        return -1;
    }

    private void createData(byte data) {
        this.data = this.type.getNewData(data);
    }

    public String toString() {
        StringBuilder toString = new StringBuilder("ItemStack{").append(this.getType().name()).append(" x ").append(this.getAmount());
        if (this.hasItemMeta()) {
            toString.append(", ").append(this.getItemMeta());
        }
        return toString.append('}').toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemStack)) {
            return false;
        }
        ItemStack stack = (ItemStack)obj;
        return this.getAmount() == stack.getAmount() && this.isSimilar(stack);
    }

    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        Material comparisonType = Bukkit.getUnsafe().fromLegacy(this.getType());
        return comparisonType == stack.getType() && this.getDurability() == stack.getDurability() && this.hasItemMeta() == stack.hasItemMeta() && (!this.hasItemMeta() || Bukkit.getItemFactory().equals(this.getItemMeta(), stack.getItemMeta()));
    }

    public ItemStack clone() {
        try {
            ItemStack itemStack = (ItemStack)super.clone();
            if (this.meta != null) {
                itemStack.meta = this.meta.clone();
            }
            if (this.data != null) {
                itemStack.data = this.data.clone();
            }
            return itemStack;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getType().hashCode();
        hash = hash * 31 + this.getAmount();
        hash = hash * 31 + (this.getDurability() & 0xFFFF);
        hash = hash * 31 + (this.hasItemMeta() ? (this.meta == null ? this.getItemMeta().hashCode() : this.meta.hashCode()) : 0);
        return hash;
    }

    public boolean containsEnchantment(Enchantment ench) {
        return this.meta == null ? false : this.meta.hasEnchant(ench);
    }

    public int getEnchantmentLevel(Enchantment ench) {
        return this.meta == null ? 0 : this.meta.getEnchantLevel(ench);
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.meta == null ? ImmutableMap.of() : this.meta.getEnchants();
    }

    public void addEnchantments(Map<Enchantment, Integer> enchantments) {
        Validate.notNull(enchantments, (String)"Enchantments cannot be null");
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            this.addEnchantment(entry.getKey(), entry.getValue());
        }
    }

    public void addEnchantment(Enchantment ench, int level) {
        Validate.notNull((Object)ench, (String)"Enchantment cannot be null");
        if (level < ench.getStartLevel() || level > ench.getMaxLevel()) {
            throw new IllegalArgumentException("Enchantment level is either too low or too high (given " + level + ", bounds are " + ench.getStartLevel() + " to " + ench.getMaxLevel() + ")");
        }
        if (!ench.canEnchantItem(this)) {
            throw new IllegalArgumentException("Specified enchantment cannot be applied to this itemstack");
        }
        this.addUnsafeEnchantment(ench, level);
    }

    public void addUnsafeEnchantments(Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            this.addUnsafeEnchantment(entry.getKey(), entry.getValue());
        }
    }

    public void addUnsafeEnchantment(Enchantment ench, int level) {
        (this.meta == null ? (this.meta = Bukkit.getItemFactory().getItemMeta(this.type)) : this.meta).addEnchant(ench, level, true);
    }

    public int removeEnchantment(Enchantment ench) {
        int level = this.getEnchantmentLevel(ench);
        if (level == 0 || this.meta == null) {
            return level;
        }
        this.meta.removeEnchant(ench);
        return level;
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("v", Bukkit.getUnsafe().getDataVersion());
        result.put("type", this.getType().name());
        if (this.getAmount() != 1) {
            result.put("amount", this.getAmount());
        }
        ItemMeta meta = this.getItemMeta();
        if (!Bukkit.getItemFactory().equals(meta, null)) {
            result.put("meta", meta);
        }
        return result;
    }

    public static ItemStack deserialize(Map<String, Object> args) {
        Object raw;
        Material type;
        int version = args.containsKey("v") ? ((Number)args.get("v")).intValue() : -1;
        short damage = 0;
        int amount = 1;
        if (args.containsKey("damage")) {
            damage = ((Number)args.get("damage")).shortValue();
        }
        if (version < 0) {
            type = Material.getMaterial("LEGACY_" + (String)args.get("type"));
            byte dataVal = type.getMaxDurability() == 0 ? (byte)damage : (byte)0;
            type = Bukkit.getUnsafe().fromLegacy(new MaterialData(type, dataVal), true);
            if (dataVal != 0) {
                damage = 0;
            }
        } else {
            type = Material.getMaterial((String)args.get("type"));
        }
        if (args.containsKey("amount")) {
            amount = ((Number)args.get("amount")).intValue();
        }
        ItemStack result = new ItemStack(type, amount, damage);
        if (args.containsKey("enchantments")) {
            Object raw2 = args.get("enchantments");
            if (raw2 instanceof Map) {
                Map map = (Map)raw2;
                for (Map.Entry entry : map.entrySet()) {
                    Enchantment enchantment = Enchantment.getByName(entry.getKey().toString());
                    if (enchantment == null || !(entry.getValue() instanceof Integer)) continue;
                    result.addUnsafeEnchantment(enchantment, (Integer)entry.getValue());
                }
            }
        } else if (args.containsKey("meta") && (raw = args.get("meta")) instanceof ItemMeta) {
            result.setItemMeta((ItemMeta)raw);
        }
        if (version < 0 && args.containsKey("damage")) {
            result.setDurability(damage);
        }
        if (args.containsKey("damage")) {
            result.setDurability(damage);
        }
        return result.ensureServerConversions();
    }

    public ItemMeta getItemMeta() {
        return this.meta == null ? Bukkit.getItemFactory().getItemMeta(this.type) : this.meta.clone();
    }

    public boolean hasItemMeta() {
        return !Bukkit.getItemFactory().equals(this.meta, null);
    }

    public boolean setItemMeta(ItemMeta itemMeta) {
        return this.setItemMeta0(itemMeta, this.type);
    }

    private boolean setItemMeta0(ItemMeta itemMeta, Material material) {
        if (itemMeta == null) {
            this.meta = null;
            return true;
        }
        if (!Bukkit.getItemFactory().isApplicable(itemMeta, material)) {
            return false;
        }
        this.meta = Bukkit.getItemFactory().asMetaFor(itemMeta, material);
        Material newType = Bukkit.getItemFactory().updateMaterial(this.meta, material);
        if (this.type != newType) {
            this.type = newType;
        }
        if (this.meta == itemMeta) {
            this.meta = itemMeta.clone();
        }
        return true;
    }

    public ItemStack ensureServerConversions() {
        return Bukkit.getServer().getItemFactory().ensureServerConversions(this);
    }

    public String getI18NDisplayName() {
        return Bukkit.getServer().getItemFactory().getI18NDisplayName(this);
    }

    public int getMaxItemUseDuration() {
        if (this.type == null || this.type == Material.AIR || !this.type.isItem()) {
            return 0;
        }
        return this.ensureServerConversions().getMaxItemUseDuration();
    }

    public ItemStack asOne() {
        return this.asQuantity(1);
    }

    public ItemStack asQuantity(int qty) {
        ItemStack clone = this.clone();
        clone.setAmount(qty);
        return clone;
    }

    public ItemStack add() {
        return this.add(1);
    }

    public ItemStack add(int qty) {
        this.setAmount(Math.min(this.getMaxStackSize(), this.getAmount() + qty));
        return this;
    }

    public ItemStack subtract() {
        return this.subtract(1);
    }

    public ItemStack subtract(int qty) {
        this.setAmount(Math.max(0, this.getAmount() - qty));
        return this;
    }

    @Nullable
    public List<String> getLore() {
        if (!this.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta = this.getItemMeta();
        if (!itemMeta.hasLore()) {
            return null;
        }
        return itemMeta.getLore();
    }

    public void setLore(List<String> lore) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setLore(lore);
        this.setItemMeta(itemMeta);
    }

    public void addItemFlags(ItemFlag ... itemFlags) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.addItemFlags(itemFlags);
        this.setItemMeta(itemMeta);
    }

    public void removeItemFlags(ItemFlag ... itemFlags) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.removeItemFlags(itemFlags);
        this.setItemMeta(itemMeta);
    }

    public Set<ItemFlag> getItemFlags() {
        ItemMeta itemMeta = this.getItemMeta();
        return itemMeta.getItemFlags();
    }

    public boolean hasItemFlag(ItemFlag flag) {
        ItemMeta itemMeta = this.getItemMeta();
        return itemMeta.hasItemFlag(flag);
    }
}

