/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin;

import com.destroystokyo.paper.event.executor.MethodHandleEventExecutor;
import com.destroystokyo.paper.event.executor.StaticMethodHandleEventExecutor;
import com.destroystokyo.paper.event.executor.asm.ASMEventExecutorGenerator;
import com.destroystokyo.paper.event.executor.asm.ClassDefiner;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;

public interface EventExecutor {
    public void execute(Listener var1, Event var2) throws EventException;

    public static EventExecutor create(Method m, final Class<? extends Event> eventClass) {
        Preconditions.checkNotNull((Object)m, (Object)"Null method");
        Preconditions.checkArgument((m.getParameterCount() != 0 ? 1 : 0) != 0, (String)"Incorrect number of arguments %s", (int)m.getParameterCount());
        Preconditions.checkArgument((m.getParameterTypes()[0] == eventClass ? 1 : 0) != 0, (String)"First parameter %s doesn't match event class %s", m.getParameterTypes()[0], eventClass);
        ClassDefiner definer = ClassDefiner.getInstance();
        if (Modifier.isStatic(m.getModifiers())) {
            return new StaticMethodHandleEventExecutor(eventClass, m);
        }
        if (definer.isBypassAccessChecks() || Modifier.isPublic(m.getDeclaringClass().getModifiers()) && Modifier.isPublic(m.getModifiers())) {
            String name = ASMEventExecutorGenerator.generateName();
            byte[] classData = ASMEventExecutorGenerator.generateEventExecutor(m, name);
            Class<EventExecutor> c = definer.defineClass(m.getDeclaringClass().getClassLoader(), name, classData).asSubclass(EventExecutor.class);
            try {
                final EventExecutor asmExecutor = c.newInstance();
                return new EventExecutor(){

                    @Override
                    public void execute(Listener listener, Event event) throws EventException {
                        if (!eventClass.isInstance(event)) {
                            return;
                        }
                        try {
                            asmExecutor.execute(listener, event);
                        }
                        catch (Exception e) {
                            throw new EventException(e);
                        }
                    }
                };
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AssertionError("Unable to initialize generated event executor", e);
            }
        }
        return new MethodHandleEventExecutor(eventClass, m);
    }
}

