/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public abstract class MetadataStoreBase<T> {
    private Map<String, Map<Plugin, MetadataValue>> metadataMap = new ConcurrentHashMap<String, Map<Plugin, MetadataValue>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadata(T subject, String metadataKey, MetadataValue newMetadataValue) {
        Validate.notNull((Object)newMetadataValue, (String)"Value cannot be null");
        Plugin owningPlugin = newMetadataValue.getOwningPlugin();
        Validate.notNull((Object)owningPlugin, (String)"Plugin cannot be null");
        String key = this.disambiguate(subject, metadataKey);
        Map<Plugin, MetadataValue> entry = this.metadataMap.get(key);
        if (entry == null) {
            entry = new WeakHashMap<Plugin, MetadataValue>(1);
            this.metadataMap.put(key, entry);
        }
        Map<Plugin, MetadataValue> map = entry;
        synchronized (map) {
            entry.put(owningPlugin, newMetadataValue);
        }
    }

    public List<MetadataValue> getMetadata(T subject, String metadataKey) {
        String key = this.disambiguate(subject, metadataKey);
        Map<Plugin, MetadataValue> entry = this.metadataMap.get(key);
        if (entry != null) {
            Collection<MetadataValue> values = entry.values();
            return Collections.unmodifiableList(new ArrayList<MetadataValue>(values));
        }
        return Collections.emptyList();
    }

    public boolean hasMetadata(T subject, String metadataKey) {
        String key = this.disambiguate(subject, metadataKey);
        return this.metadataMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetadata(T subject, String metadataKey, Plugin owningPlugin) {
        Validate.notNull((Object)owningPlugin, (String)"Plugin cannot be null");
        String key = this.disambiguate(subject, metadataKey);
        Map<Plugin, MetadataValue> entry = this.metadataMap.get(key);
        if (entry == null) {
            return;
        }
        Map<Plugin, MetadataValue> map = entry;
        synchronized (map) {
            entry.remove(owningPlugin);
            if (entry.isEmpty()) {
                this.metadataMap.remove(key);
            }
        }
    }

    public void invalidateAll(Plugin owningPlugin) {
        Validate.notNull((Object)owningPlugin, (String)"Plugin cannot be null");
        for (Map<Plugin, MetadataValue> values : this.metadataMap.values()) {
            if (!values.containsKey(owningPlugin)) continue;
            values.get(owningPlugin).invalidate();
        }
    }

    public void removeAll(Plugin owningPlugin) {
        Validate.notNull((Object)owningPlugin, (String)"Plugin cannot be null");
        Iterator<Map<Plugin, MetadataValue>> iterator = this.metadataMap.values().iterator();
        while (iterator.hasNext()) {
            Map<Plugin, MetadataValue> values = iterator.next();
            if (values.containsKey(owningPlugin)) {
                values.remove(owningPlugin);
            }
            if (!values.isEmpty()) continue;
            iterator.remove();
        }
    }

    protected abstract String disambiguate(T var1, String var2);
}

