package org.bukkit.event.player;

import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;

/**
 * Thrown when a player attempts to pick an item up from the ground
 */
public class PlayerAttemptPickupItemEvent extends PlayerEvent {
    private static final HandlerList handlers = new HandlerList();
    private final Item item;

    public PlayerAttemptPickupItemEvent(final Player player, final Item item) {
        super(player);
        this.item = item;
    }

    /**
     * Gets the Item attempted by the player.
     *
     * @return Item
     */
    public Item getItem() {
        return item;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}
