/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.util;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class JSONUtil {
    private JSONUtil() {
    }

    public static JSONPair pair(String key, Object obj) {
        return new JSONPair(key, obj);
    }

    public static JSONPair pair(long key, Object obj) {
        return new JSONPair(String.valueOf(key), obj);
    }

    public static Map createObject(JSONPair ... data) {
        return JSONUtil.appendObjectData(new LinkedHashMap(), data);
    }

    public static Map appendObjectData(Map parent, JSONPair ... data) {
        JSONPair[] jSONPairArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            JSONPair JSONPair2 = jSONPairArray[n2];
            parent.put(JSONPair2.key, JSONPair2.val);
            ++n2;
        }
        return parent;
    }

    public static List toArray(Object ... data) {
        return Lists.newArrayList((Object[])data);
    }

    public static <E> List toArrayMapper(E[] collection, Function<E, Object> mapper) {
        return JSONUtil.toArrayMapper(Lists.newArrayList((Object[])collection), mapper);
    }

    public static <E> List toArrayMapper(Iterable<E> collection, Function<E, Object> mapper) {
        ArrayList array = Lists.newArrayList();
        for (E e : collection) {
            Object object = mapper.apply(e);
            if (object == null) continue;
            array.add(object);
        }
        return array;
    }

    public static <E> Map toObjectMapper(E[] collection, Function<E, JSONPair> mapper) {
        return JSONUtil.toObjectMapper(Lists.newArrayList((Object[])collection), mapper);
    }

    public static <E> Map toObjectMapper(Iterable<E> collection, Function<E, JSONPair> mapper) {
        LinkedHashMap object = Maps.newLinkedHashMap();
        for (E e : collection) {
            JSONPair JSONPair2 = (JSONPair)mapper.apply(e);
            if (JSONPair2 == null) continue;
            object.put(JSONPair2.key, JSONPair2.val);
        }
        return object;
    }

    public static class JSONPair {
        final String key;
        final Object val;

        JSONPair(String key, Object val) {
            this.key = key;
            this.val = val;
        }
    }
}

