/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.TimingHandler;
import co.aikar.timings.TimingHistory;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import co.aikar.timings.TimingsReportListener;
import co.aikar.util.JSONUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

class TimingsExport
extends Thread {
    private final TimingsReportListener listeners;
    private final Map out;
    private final TimingHistory[] history;
    private static long lastReport = 0L;
    static final List<CommandSender> requestingReport = Lists.newArrayList();

    private TimingsExport(TimingsReportListener listeners, Map out, TimingHistory[] history) {
        super("Timings paste thread");
        this.listeners = listeners;
        this.out = out;
        this.history = history;
    }

    static void reportTimings() {
        if (requestingReport.isEmpty()) {
            return;
        }
        TimingsReportListener listeners = new TimingsReportListener(requestingReport);
        listeners.addConsoleIfNeeded();
        requestingReport.clear();
        long now = System.currentTimeMillis();
        long lastReportDiff = now - lastReport;
        if (lastReportDiff < 60000L) {
            listeners.sendMessage((Object)((Object)ChatColor.RED) + "Please wait at least 1 minute in between Timings reports. (" + (int)((60000L - lastReportDiff) / 1000L) + " seconds)");
            listeners.done();
            return;
        }
        long lastStartDiff = now - TimingsManager.timingStart;
        if (lastStartDiff < 180000L) {
            listeners.sendMessage((Object)((Object)ChatColor.RED) + "Please wait at least 3 minutes before generating a Timings report. Unlike Timings v1, v2 benefits from longer timings and is not as useful with short timings. (" + (int)((180000L - lastStartDiff) / 1000L) + " seconds)");
            listeners.done();
            return;
        }
        listeners.sendMessage((Object)((Object)ChatColor.GREEN) + "Preparing Timings Report...");
        lastReport = now;
        Map parent = JSONUtil.createObject(JSONUtil.pair("version", (Object)Bukkit.getVersion()), JSONUtil.pair("maxplayers", (Object)Bukkit.getMaxPlayers()), JSONUtil.pair("start", (Object)(TimingsManager.timingStart / 1000L)), JSONUtil.pair("end", (Object)(System.currentTimeMillis() / 1000L)), JSONUtil.pair("sampletime", (Object)((System.currentTimeMillis() - TimingsManager.timingStart) / 1000L)));
        if (!TimingsManager.privacy) {
            JSONUtil.appendObjectData(parent, JSONUtil.pair("server", (Object)Bukkit.getServerName()), JSONUtil.pair("motd", (Object)Bukkit.getServer().getMotd()), JSONUtil.pair("online-mode", (Object)Bukkit.getServer().getOnlineMode()), JSONUtil.pair("icon", (Object)Bukkit.getServer().getServerIcon().getData()));
        }
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        parent.put("system", JSONUtil.createObject(JSONUtil.pair("timingcost", (Object)TimingsExport.getCost()), JSONUtil.pair("name", (Object)System.getProperty("os.name")), JSONUtil.pair("version", (Object)System.getProperty("os.version")), JSONUtil.pair("jvmversion", (Object)System.getProperty("java.version")), JSONUtil.pair("arch", (Object)System.getProperty("os.arch")), JSONUtil.pair("maxmem", (Object)runtime.maxMemory()), JSONUtil.pair("cpu", (Object)runtime.availableProcessors()), JSONUtil.pair("runtime", (Object)ManagementFactory.getRuntimeMXBean().getUptime()), JSONUtil.pair("flags", (Object)StringUtils.join(runtimeBean.getInputArguments(), (String)" ")), JSONUtil.pair("gc", (Object)JSONUtil.toObjectMapper(ManagementFactory.getGarbageCollectorMXBeans(), input -> JSONUtil.pair(input.getName(), (Object)JSONUtil.toArray(input.getCollectionCount(), input.getCollectionTime()))))));
        HashSet tileEntityTypeSet = Sets.newHashSet();
        HashSet entityTypeSet = Sets.newHashSet();
        int size = TimingsManager.HISTORY.size();
        TimingHistory[] history = new TimingHistory[size + 1];
        int i = 0;
        for (TimingHistory timingHistory : TimingsManager.HISTORY) {
            tileEntityTypeSet.addAll(timingHistory.tileEntityTypeSet);
            entityTypeSet.addAll(timingHistory.entityTypeSet);
            history[i++] = timingHistory;
        }
        history[i] = new TimingHistory();
        tileEntityTypeSet.addAll(history[i].tileEntityTypeSet);
        entityTypeSet.addAll(history[i].entityTypeSet);
        Map handlers = JSONUtil.createObject(new JSONUtil.JSONPair[0]);
        for (TimingIdentifier.TimingGroup group2 : TimingIdentifier.GROUP_MAP.values()) {
            for (TimingHandler id : group2.handlers) {
                if (!id.isTimed() && !id.isSpecial()) continue;
                handlers.put(id.id, JSONUtil.toArray(group2.id, id.name));
            }
        }
        parent.put("idmap", JSONUtil.createObject(JSONUtil.pair("groups", (Object)JSONUtil.toObjectMapper(TimingIdentifier.GROUP_MAP.values(), group -> JSONUtil.pair(group.id, (Object)group.name))), JSONUtil.pair("handlers", (Object)handlers), JSONUtil.pair("worlds", (Object)JSONUtil.toObjectMapper(TimingHistory.worldMap.entrySet(), input -> JSONUtil.pair(((Integer)input.getValue()).intValue(), input.getKey()))), JSONUtil.pair("tileentity", (Object)JSONUtil.toObjectMapper(tileEntityTypeSet, input -> JSONUtil.pair(input.getId(), (Object)input.name()))), JSONUtil.pair("entity", (Object)JSONUtil.toObjectMapper(entityTypeSet, input -> JSONUtil.pair(input.getTypeId(), (Object)input.name())))));
        parent.put("plugins", JSONUtil.toObjectMapper(Bukkit.getPluginManager().getPlugins(), plugin -> JSONUtil.pair(plugin.getName(), (Object)JSONUtil.createObject(JSONUtil.pair("version", (Object)plugin.getDescription().getVersion()), JSONUtil.pair("description", (Object)String.valueOf(plugin.getDescription().getDescription()).trim()), JSONUtil.pair("website", (Object)plugin.getDescription().getWebsite()), JSONUtil.pair("authors", (Object)StringUtils.join(plugin.getDescription().getAuthors(), (String)", "))))));
        parent.put("config", JSONUtil.createObject(JSONUtil.pair("spigot", (Object)TimingsExport.mapAsJSON(Bukkit.spigot().getSpigotConfig(), null)), JSONUtil.pair("bukkit", (Object)TimingsExport.mapAsJSON(Bukkit.spigot().getBukkitConfig(), null)), JSONUtil.pair("paper", (Object)TimingsExport.mapAsJSON(Bukkit.spigot().getPaperConfig(), null))));
        new TimingsExport(listeners, parent, history).start();
    }

    static long getCost() {
        int passes = 100;
        TimingHandler SAMPLER1 = Timings.ofSafe("Timings Sampler 1");
        TimingHandler SAMPLER2 = Timings.ofSafe("Timings Sampler 2");
        TimingHandler SAMPLER3 = Timings.ofSafe("Timings Sampler 3");
        TimingHandler SAMPLER4 = Timings.ofSafe("Timings Sampler 4");
        TimingHandler SAMPLER5 = Timings.ofSafe("Timings Sampler 5");
        TimingHandler SAMPLER6 = Timings.ofSafe("Timings Sampler 6");
        long start = System.nanoTime();
        int i = 0;
        while (i < passes) {
            SAMPLER1.startTiming();
            SAMPLER2.startTiming();
            SAMPLER3.startTiming();
            SAMPLER3.stopTiming();
            SAMPLER4.startTiming();
            SAMPLER5.startTiming();
            SAMPLER6.startTiming();
            SAMPLER6.stopTiming();
            SAMPLER5.stopTiming();
            SAMPLER4.stopTiming();
            SAMPLER2.stopTiming();
            SAMPLER1.stopTiming();
            ++i;
        }
        long timingsCost = (System.nanoTime() - start) / (long)passes / 6L;
        SAMPLER1.reset(true);
        SAMPLER2.reset(true);
        SAMPLER3.reset(true);
        SAMPLER4.reset(true);
        SAMPLER5.reset(true);
        SAMPLER6.reset(true);
        return timingsCost;
    }

    private static JSONObject mapAsJSON(ConfigurationSection config, String parentKey) {
        JSONObject object = new JSONObject();
        for (String key : config.getKeys(false)) {
            String fullKey;
            String string = fullKey = parentKey != null ? String.valueOf(parentKey) + "." + key : key;
            if (fullKey.equals("database") || fullKey.equals("settings.bungeecord-addresses") || TimingsManager.hiddenConfigs.contains(fullKey)) continue;
            Object val = config.get(key);
            object.put((Object)key, TimingsExport.valAsJSON(val, fullKey));
        }
        return object;
    }

    private static Object valAsJSON(Object val, String parentKey) {
        if (!(val instanceof MemorySection)) {
            if (val instanceof List) {
                Iterable v = (Iterable)val;
                return JSONUtil.toArrayMapper(v, input -> TimingsExport.valAsJSON(input, parentKey));
            }
            return val.toString();
        }
        return TimingsExport.mapAsJSON((ConfigurationSection)val, parentKey);
    }

    @Override
    public void run() {
        String timingsURL;
        block10: {
            HttpURLConnection con;
            String response;
            block9: {
                this.out.put("data", JSONUtil.toArrayMapper(this.history, TimingHistory::export));
                response = null;
                timingsURL = null;
                con = (HttpURLConnection)new URL("http://timings.aikar.co/post").openConnection();
                con.setDoOutput(true);
                String hostName = "BrokenHost";
                try {
                    hostName = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {}
                con.setRequestProperty("User-Agent", "Paper/" + Bukkit.getServerName() + "/" + hostName);
                con.setRequestMethod("POST");
                con.setInstanceFollowRedirects(false);
                GZIPOutputStream request = new GZIPOutputStream(con.getOutputStream()){
                    {
                        this.def.setLevel(7);
                    }
                };
                ((OutputStream)request).write(JSONValue.toJSONString((Object)this.out).getBytes("UTF-8"));
                ((OutputStream)request).close();
                response = this.getResponse(con);
                if (con.getResponseCode() == 302) break block9;
                this.listeners.sendMessage((Object)((Object)ChatColor.RED) + "Upload Error: " + con.getResponseCode() + ": " + con.getResponseMessage());
                this.listeners.sendMessage((Object)((Object)ChatColor.RED) + "Check your logs for more information");
                if (response != null) {
                    Bukkit.getLogger().log(Level.SEVERE, response);
                }
                this.listeners.done(timingsURL);
                return;
            }
            try {
                try {
                    timingsURL = con.getHeaderField("Location");
                    this.listeners.sendMessage((Object)((Object)ChatColor.GREEN) + "View Timings Report: " + timingsURL);
                    if (response == null || response.isEmpty()) break block10;
                    Bukkit.getLogger().log(Level.INFO, "Timing Response: " + response);
                }
                catch (IOException ex) {
                    this.listeners.sendMessage((Object)((Object)ChatColor.RED) + "Error uploading timings, check your logs for more information");
                    if (response != null) {
                        Bukkit.getLogger().log(Level.SEVERE, response);
                    }
                    Bukkit.getLogger().log(Level.SEVERE, "Could not paste timings", ex);
                    this.listeners.done(timingsURL);
                }
            }
            catch (Throwable throwable) {
                this.listeners.done(timingsURL);
                throw throwable;
            }
        }
        this.listeners.done(timingsURL);
    }

    private String getResponse(HttpURLConnection con) throws IOException {
        try (InputStream is = null;){
            int bytesRead;
            is = con.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((bytesRead = is.read(b)) != -1) {
                bos.write(b, 0, bytesRead);
            }
            String string = bos.toString();
            return string;
        }
    }
}

