/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.executor.asm;

import com.destroystokyo.paper.event.executor.asm.ClassDefiner;
import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SafeClassDefiner
implements ClassDefiner {
    static final SafeClassDefiner INSTANCE = new SafeClassDefiner();
    private final ConcurrentMap<ClassLoader, GeneratedClassLoader> loaders = new ConcurrentHashMap<ClassLoader, GeneratedClassLoader>();

    private SafeClassDefiner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> defineClass(ClassLoader parentLoader, String name, byte[] data) {
        GeneratedClassLoader loader = this.loaders.computeIfAbsent(parentLoader, GeneratedClassLoader::new);
        Object object = loader.getClassLoadingLock(name);
        synchronized (object) {
            Preconditions.checkState((!loader.hasClass(name) ? 1 : 0) != 0, (String)"%s already defined", (Object)name);
            Class c = loader.define(name, data);
            assert (c.getName().equals(name));
            return c;
        }
    }

    private static class GeneratedClassLoader
    extends ClassLoader {
        static {
            ClassLoader.registerAsParallelCapable();
        }

        protected GeneratedClassLoader(ClassLoader parent) {
            super(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> define(String name, byte[] data) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                assert (!this.hasClass(name));
                Class<?> c = this.defineClass(name, data, 0, data.length);
                this.resolveClass(c);
                return c;
            }
        }

        @Override
        public Object getClassLoadingLock(String name) {
            return super.getClassLoadingLock(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasClass(String name) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                try {
                    Class.forName(name);
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
            }
        }
    }
}

