/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.profile;

import com.destroystokyo.paper.event.profile.LookupProfileEvent;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PreLookupProfileEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final String name;
    private UUID uuid;
    private PropertyMap properties = new PropertyMap();

    public PreLookupProfileEvent(@Nonnull String name) {
        super(!Bukkit.isPrimaryThread());
        this.name = name;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(@Nullable UUID uuid) {
        this.uuid = uuid;
    }

    @Nonnull
    public Multimap<String, Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Multimap<String, Property> properties) {
        this.properties = new PropertyMap();
        this.properties.putAll(properties);
    }

    public void addProperties(Multimap<String, Property> properties) {
        this.properties.putAll(properties);
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static GameProfileRepository wrapProfileRepository(GameProfileRepository orig) {
        return (names, agent, callback) -> {
            HashSet unfoundNames = Sets.newHashSet();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                PreLookupProfileEvent event = new PreLookupProfileEvent(name);
                event.callEvent();
                if (event.getUUID() != null) {
                    GameProfile gameprofile = new GameProfile(event.getUUID(), name);
                    gameprofile.getProperties().putAll(event.getProperties());
                    callback.onProfileLookupSucceeded(gameprofile);
                } else {
                    unfoundNames.add(name);
                }
                ++n2;
            }
            if (!unfoundNames.isEmpty() && orig != null) {
                String[] namesArr = unfoundNames.toArray(new String[unfoundNames.size()]);
                orig.findProfilesByNames(namesArr, agent, (ProfileLookupCallback)new PreProfileLookupCallback(callback));
            }
        };
    }

    private static class PreProfileLookupCallback
    implements ProfileLookupCallback {
        private final ProfileLookupCallback callback;

        PreProfileLookupCallback(ProfileLookupCallback callback) {
            this.callback = callback;
        }

        public void onProfileLookupSucceeded(GameProfile gameProfile) {
            new LookupProfileEvent(gameProfile).callEvent();
            this.callback.onProfileLookupSucceeded(gameProfile);
        }

        public void onProfileLookupFailed(GameProfile gameProfile, Exception e) {
            this.callback.onProfileLookupFailed(gameProfile, e);
        }
    }
}

