package com.destroystokyo.paper.event.profile;

import com.mojang.authlib.GameProfile;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

import javax.annotation.Nonnull;

/**
 * Allows a plugin to be notified anytime AFTER a Profile has been looked up from the Mojang API
 * This is an opportunity to view the response and potentially cache things.
 *
 * No guarantees are made about thread execution context for this event. If you need to know, check
 * event.isAsync()
 */
public class LookupProfileEvent extends Event {

    private static final HandlerList handlers = new HandlerList();

    private final GameProfile profile;

    public LookupProfileEvent(@Nonnull GameProfile profile) {
        super(!Bukkit.isPrimaryThread());
        this.profile = profile;
    }

    /**
     * @return The profile that was recently looked up. This profile can be mutated
     */
    @Nonnull
    public GameProfile getProfile() {
        return profile;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}
