/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingHandler;
import co.aikar.util.LoadingMap;
import co.aikar.util.MRUMapCache;
import com.google.common.base.Function;
import java.util.ArrayDeque;
import java.util.Map;

final class TimingIdentifier {
    static final Map<String, TimingGroup> GROUP_MAP = MRUMapCache.of(LoadingMap.newIdentityHashMap(new Function<String, TimingGroup>(){

        public TimingGroup apply(String group) {
            return new TimingGroup(group);
        }
    }, 64));
    static final TimingGroup DEFAULT_GROUP = TimingIdentifier.getGroup("Minecraft");
    final String group;
    final String name;
    final TimingHandler groupHandler;
    final boolean protect;
    private final int hashCode;

    TimingIdentifier(String group, String name, Timing groupHandler, boolean protect) {
        this.group = group != null ? group.intern() : TimingIdentifier.DEFAULT_GROUP.name;
        this.name = name.intern();
        this.groupHandler = groupHandler != null ? groupHandler.getTimingHandler() : null;
        this.protect = protect;
        this.hashCode = 31 * this.group.hashCode() + this.name.hashCode();
    }

    static TimingGroup getGroup(String groupName) {
        if (groupName == null) {
            return DEFAULT_GROUP;
        }
        return GROUP_MAP.get(groupName.intern());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        TimingIdentifier that = (TimingIdentifier)o;
        return this.group == that.group && this.name == that.name;
    }

    public int hashCode() {
        return this.hashCode;
    }

    static class TimingGroup {
        private static int idPool = 1;
        final int id = idPool++;
        final String name;
        ArrayDeque<TimingHandler> handlers = new ArrayDeque(64);

        private TimingGroup(String name) {
            this.name = name;
        }
    }
}

