/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.FullServerTickHandler;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingHandler;
import co.aikar.timings.TimingHistory;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.UnsafeTimingHandler;
import co.aikar.util.LoadingMap;
import com.google.common.base.Function;
import com.google.common.collect.EvictingQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.PluginClassLoader;

public final class TimingsManager {
    static final Map<TimingIdentifier, TimingHandler> TIMING_MAP = Collections.synchronizedMap(LoadingMap.newHashMap(new Function<TimingIdentifier, TimingHandler>(){

        public TimingHandler apply(TimingIdentifier id) {
            return id.protect ? new UnsafeTimingHandler(id) : new TimingHandler(id);
        }
    }, 256, 0.5f));
    public static final FullServerTickHandler FULL_SERVER_TICK = new FullServerTickHandler();
    public static final TimingHandler TIMINGS_TICK = Timings.ofSafe("Timings Tick", FULL_SERVER_TICK);
    public static final Timing PLUGIN_GROUP_HANDLER = Timings.ofSafe("Plugins");
    public static List<String> hiddenConfigs = new ArrayList<String>();
    public static boolean privacy = false;
    static final Collection<TimingHandler> HANDLERS = new ArrayDeque<TimingHandler>();
    static final ArrayDeque<TimingHistory.MinuteReport> MINUTE_REPORTS = new ArrayDeque();
    static EvictingQueue<TimingHistory> HISTORY = EvictingQueue.create((int)12);
    static TimingHandler CURRENT;
    static long timingStart;
    static long historyStart;
    static boolean needsFullReset;
    static boolean needsRecheckEnabled;

    static {
        timingStart = 0L;
        historyStart = 0L;
        needsFullReset = false;
        needsRecheckEnabled = false;
    }

    private TimingsManager() {
    }

    static void reset() {
        needsFullReset = true;
    }

    static void tick() {
        if (Timings.timingsEnabled) {
            boolean violated = FULL_SERVER_TICK.isViolated();
            for (TimingHandler handler : HANDLERS) {
                if (handler.isSpecial()) continue;
                handler.processTick(violated);
            }
            TimingHistory.playerTicks += (long)Bukkit.getOnlinePlayers().size();
            ++TimingHistory.timedTicks;
        }
    }

    static void stopServer() {
        Timings.timingsEnabled = false;
        TimingsManager.recheckEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recheckEnabled() {
        Map<TimingIdentifier, TimingHandler> map = TIMING_MAP;
        synchronized (map) {
            for (TimingHandler timings : TIMING_MAP.values()) {
                timings.checkEnabled();
            }
        }
        needsRecheckEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetTimings() {
        if (needsFullReset) {
            Map<TimingIdentifier, TimingHandler> map = TIMING_MAP;
            synchronized (map) {
                for (TimingHandler timings : TIMING_MAP.values()) {
                    timings.reset(true);
                }
            }
            Bukkit.getLogger().log(Level.INFO, "Timings Reset");
            HISTORY.clear();
            needsFullReset = false;
            needsRecheckEnabled = false;
            timingStart = System.currentTimeMillis();
        } else {
            for (TimingHandler timings : HANDLERS) {
                timings.reset(false);
            }
        }
        HANDLERS.clear();
        MINUTE_REPORTS.clear();
        TimingHistory.resetTicks(true);
        historyStart = System.currentTimeMillis();
    }

    static TimingHandler getHandler(String group, String name, Timing parent, boolean protect) {
        return TIMING_MAP.get(new TimingIdentifier(group, name, parent, protect));
    }

    public static Timing getCommandTiming(String pluginName, Command command) {
        Plugin plugin = null;
        Server server = Bukkit.getServer();
        if (!(server == null || pluginName == null || "minecraft".equals(pluginName) || "bukkit".equals(pluginName) || "spigot".equalsIgnoreCase(pluginName) || "paper".equals(pluginName))) {
            plugin = server.getPluginManager().getPlugin(pluginName);
        }
        if (plugin == null) {
            plugin = TimingsManager.getPluginByClassloader(command.getClass());
        }
        if (plugin == null) {
            return Timings.ofSafe("Command: " + pluginName + ":" + command.getTimingName());
        }
        return Timings.ofSafe(plugin, "Command: " + pluginName + ":" + command.getTimingName());
    }

    public static Plugin getPluginByClassloader(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof PluginClassLoader) {
            PluginClassLoader pluginClassLoader = (PluginClassLoader)classLoader;
            return pluginClassLoader.getPlugin();
        }
        return null;
    }
}

