/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.entity.Player;

@Deprecated
public class SpawnpointCommand
extends VanillaCommand {
    public SpawnpointCommand() {
        super("spawnpoint");
        this.description = "Sets a player's spawn point";
        this.usageMessage = "/spawnpoint OR /spawnpoint <player> OR /spawnpoint <player> <x> <y> <z>";
        this.setPermission("bukkit.command.spawnpoint");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        Player player;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Please provide a player!");
                return true;
            }
            player = (Player)sender;
        } else {
            player = Bukkit.getPlayerExact(args[0]);
            if (player == null) {
                sender.sendMessage("Can't find player " + args[0]);
                return true;
            }
        }
        World world = player.getWorld();
        if (args.length == 4) {
            int z;
            int y;
            int x;
            if (world == null) return true;
            int pos = 1;
            try {
                x = this.getInteger(sender, args[pos++], -30000000, 30000000, true);
                y = this.getInteger(sender, args[pos++], 0, world.getMaxHeight());
                z = this.getInteger(sender, args[pos], -30000000, 30000000, true);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(ex.getMessage());
                return true;
            }
            player.setBedSpawnLocation(new Location(world, x, y, z), true);
            Command.broadcastCommandMessage(sender, "Set " + player.getDisplayName() + "'s spawnpoint to " + x + ", " + y + ", " + z);
            return true;
        }
        if (args.length <= 1) {
            Location location = player.getLocation();
            player.setBedSpawnLocation(location, true);
            Command.broadcastCommandMessage(sender, "Set " + player.getDisplayName() + "'s spawnpoint to " + location.getX() + ", " + location.getY() + ", " + location.getZ());
            return true;
        }
        sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return super.tabComplete(sender, alias, args);
        }
        return ImmutableList.of();
    }
}

