/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.NullTimingHandler;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingHandler;
import co.aikar.timings.TimingHistory;
import co.aikar.timings.TimingsExport;
import co.aikar.timings.TimingsManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public final class Timings {
    private static final int MAX_HISTORY_FRAMES = 12;
    public static final Timing NULL_HANDLER = new NullTimingHandler();
    static boolean timingsEnabled = false;
    static boolean verboseEnabled = false;
    private static int historyInterval = -1;
    private static int historyLength = -1;

    private Timings() {
    }

    public static Timing of(Plugin plugin, String name) {
        TimingHandler pluginHandler = null;
        if (plugin != null) {
            pluginHandler = Timings.ofSafe(plugin.getName(), "Combined Total", TimingsManager.PLUGIN_GROUP_HANDLER);
        }
        return Timings.of(plugin, name, pluginHandler);
    }

    public static Timing of(Plugin plugin, String name, Timing groupHandler) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin can not be null");
        return TimingsManager.getHandler(plugin.getName(), name, groupHandler, true);
    }

    public static Timing ofStart(Plugin plugin, String name) {
        return Timings.ofStart(plugin, name, null);
    }

    public static Timing ofStart(Plugin plugin, String name, Timing groupHandler) {
        Timing timing = Timings.of(plugin, name, groupHandler);
        timing.startTimingIfSync();
        return timing;
    }

    public static boolean isTimingsEnabled() {
        return timingsEnabled;
    }

    public static void setTimingsEnabled(boolean enabled) {
        timingsEnabled = enabled;
        Timings.reset();
        if (Boolean.getBoolean("timings.throwOnChange")) {
            new RuntimeException("The enable state of timings has been changed to: " + enabled).printStackTrace();
        }
    }

    public static boolean isVerboseTimingsEnabled() {
        return verboseEnabled;
    }

    public static void setVerboseTimingsEnabled(boolean enabled) {
        verboseEnabled = enabled;
        TimingsManager.needsRecheckEnabled = true;
    }

    public static int getHistoryInterval() {
        return historyInterval;
    }

    public static void setHistoryInterval(int interval) {
        historyInterval = Math.max(1200, interval);
        if (historyLength != -1) {
            Timings.setHistoryLength(historyLength);
        }
    }

    public static int getHistoryLength() {
        return historyLength;
    }

    public static void setHistoryLength(int length) {
        int maxLength = historyInterval * 12;
        if (System.getProperty("timings.bypassMax") != null) {
            maxLength = Integer.MAX_VALUE;
        }
        historyLength = Math.max(Math.min(maxLength, length), historyInterval);
        EvictingQueue<TimingHistory> oldQueue = TimingsManager.HISTORY;
        int frames = Timings.getHistoryLength() / Timings.getHistoryInterval();
        if (length > maxLength) {
            Bukkit.getLogger().log(Level.WARNING, "Timings Length too high. Requested " + length + ", max is " + maxLength + ". To get longer history, you must increase your interval. Set Interval to " + Math.ceil(length / 12) + " to achieve this length.");
        }
        TimingsManager.HISTORY = EvictingQueue.create((int)frames);
        TimingsManager.HISTORY.addAll(oldQueue);
    }

    public static void reset() {
        TimingsManager.reset();
    }

    public static void generateReport(CommandSender sender) {
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        TimingsExport.reportTimings(sender);
    }

    static TimingHandler ofSafe(String name) {
        return Timings.ofSafe(null, name, null);
    }

    static Timing ofSafe(Plugin plugin, String name) {
        TimingHandler pluginHandler = null;
        if (plugin != null) {
            pluginHandler = Timings.ofSafe(plugin.getName(), "Combined Total", TimingsManager.PLUGIN_GROUP_HANDLER);
        }
        return Timings.ofSafe(plugin != null ? plugin.getName() : "Minecraft - Invalid Plugin", name, pluginHandler);
    }

    static TimingHandler ofSafe(String name, Timing groupHandler) {
        return Timings.ofSafe(null, name, groupHandler);
    }

    static TimingHandler ofSafe(String groupName, String name, Timing groupHandler) {
        return TimingsManager.getHandler(groupName, name, groupHandler, false);
    }
}

