package org.bukkit.event.entity;

import org.bukkit.entity.Entity; // Paper
import org.bukkit.entity.Projectile;
import org.bukkit.event.HandlerList;

import javax.annotation.Nullable;

/**
 * Called when a projectile hits an object
 */
public class ProjectileHitEvent extends EntityEvent {
    private static final HandlerList handlers = new HandlerList();
    // Paper start
    @Nullable
    private final Entity hitEntity;

    public ProjectileHitEvent(final Projectile projectile) {
        this(projectile, null);
    }

    public ProjectileHitEvent(final Projectile projectile, @Nullable final Entity hitEntity) {
        super(projectile);
        this.hitEntity = hitEntity;
    }
    // Paper end

    @Override
    public Projectile getEntity() {
        return (Projectile) entity;
    }

    // Paper start
    /**
     * Gets the entity that was hit by the projectile.
     *
     * This may be null, depending on if the projectile
     * actually hit an entity.
     *
     * @return The entity that was hit, or null otherwise
     */
    @Nullable
    public Entity getHitEntity() {
        return hitEntity;
    }
    // Paper end

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

}
