/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.querybuilder;

import com.datastax.dse.driver.api.querybuilder.schema.CreateDseAggregateStart;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseFunctionStart;
import com.datastax.dse.driver.internal.querybuilder.schema.DefaultCreateDseAggregate;
import com.datastax.dse.driver.internal.querybuilder.schema.DefaultCreateDseFunction;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateAggregateStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateFunctionStart;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class DseSchemaBuilder
extends SchemaBuilder {
    @NonNull
    public static CreateDseAggregateStart createDseAggregate(@NonNull CqlIdentifier aggregateId) {
        return new DefaultCreateDseAggregate(aggregateId);
    }

    @NonNull
    public static CreateDseAggregateStart createDseAggregate(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier aggregateId) {
        return new DefaultCreateDseAggregate(keyspaceId, aggregateId);
    }

    @NonNull
    public static CreateDseAggregateStart createDseAggregate(@NonNull String aggregateName) {
        return new DefaultCreateDseAggregate(CqlIdentifier.fromCql((String)aggregateName));
    }

    @NonNull
    public static CreateDseAggregateStart createDseAggregate(@Nullable String keyspaceName, @NonNull String aggregateName) {
        return new DefaultCreateDseAggregate(keyspaceName == null ? null : CqlIdentifier.fromCql((String)keyspaceName), CqlIdentifier.fromCql((String)aggregateName));
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@NonNull CqlIdentifier aggregateName) {
        return SchemaBuilder.createAggregate(aggregateName);
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier aggregateName) {
        return SchemaBuilder.createAggregate(keyspace, aggregateName);
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@NonNull String aggregateName) {
        return SchemaBuilder.createAggregate(aggregateName);
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@Nullable String keyspace, @NonNull String aggregateName) {
        return SchemaBuilder.createAggregate(keyspace, aggregateName);
    }

    @NonNull
    public static CreateDseFunctionStart createDseFunction(@NonNull CqlIdentifier functionId) {
        return new DefaultCreateDseFunction(functionId);
    }

    @NonNull
    public static CreateDseFunctionStart createDseFunction(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId) {
        return new DefaultCreateDseFunction(keyspaceId, functionId);
    }

    @NonNull
    public static CreateDseFunctionStart createDseFunction(@NonNull String functionName) {
        return new DefaultCreateDseFunction(CqlIdentifier.fromCql((String)functionName));
    }

    @NonNull
    public static CreateDseFunctionStart createDseFunction(@Nullable String keyspaceName, @NonNull String functionName) {
        return new DefaultCreateDseFunction(keyspaceName == null ? null : CqlIdentifier.fromCql((String)keyspaceName), CqlIdentifier.fromCql((String)functionName));
    }

    @NonNull
    public static CreateFunctionStart createFunction(@NonNull CqlIdentifier functionName) {
        return SchemaBuilder.createFunction(functionName);
    }

    @NonNull
    public static CreateFunctionStart createFunction(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier functionName) {
        return SchemaBuilder.createFunction(keyspace, functionName);
    }

    @NonNull
    public static CreateFunctionStart createFunction(@NonNull String functionName) {
        return SchemaBuilder.createFunction(functionName);
    }

    @NonNull
    public static CreateFunctionStart createFunction(@Nullable String keyspace, @NonNull String functionName) {
        return SchemaBuilder.createFunction(keyspace, functionName);
    }
}

