/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.mapper.reactive;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.dse.driver.api.core.cql.reactive.ReactiveRow;
import com.datastax.dse.driver.api.mapper.reactive.MappedReactiveResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMappedReactiveResultSet<EntityT>
implements MappedReactiveResultSet<EntityT> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMappedReactiveResultSet.class);
    private static final Subscription EMPTY_SUBSCRIPTION = new Subscription(){

        public void request(long n) {
        }

        public void cancel() {
        }
    };
    @NonNull
    private final ReactiveResultSet source;
    @NonNull
    private final Function<ReactiveRow, EntityT> mapper;

    public DefaultMappedReactiveResultSet(@NonNull ReactiveResultSet source, @NonNull Function<ReactiveRow, EntityT> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @NonNull
    public Publisher<? extends ColumnDefinitions> getColumnDefinitions() {
        return this.source.getColumnDefinitions();
    }

    @NonNull
    public Publisher<? extends ExecutionInfo> getExecutionInfos() {
        return this.source.getExecutionInfos();
    }

    @NonNull
    public Publisher<Boolean> wasApplied() {
        return this.source.wasApplied();
    }

    public void subscribe(@NonNull Subscriber<? super EntityT> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber cannot be null");
        MappedReactiveResultSetSubscriber s = new MappedReactiveResultSetSubscriber(subscriber);
        try {
            this.source.subscribe((Subscriber)s);
        }
        catch (Throwable t) {
            s.cancel();
            IllegalStateException error = new IllegalStateException("Publisher violated $1.9 by throwing an exception from subscribe.", t);
            LOG.error(error.getMessage(), error.getCause());
            subscriber.onSubscribe(EMPTY_SUBSCRIPTION);
            subscriber.onError((Throwable)error);
        }
    }

    private class MappedReactiveResultSetSubscriber
    implements Subscriber<ReactiveRow>,
    Subscription {
        private volatile Subscriber<? super EntityT> downstreamSubscriber;
        private volatile Subscription upstreamSubscription;
        private volatile boolean terminated;

        MappedReactiveResultSetSubscriber(Subscriber<? super EntityT> subscriber) {
            this.downstreamSubscriber = subscriber;
        }

        public void onSubscribe(@NonNull Subscription subscription) {
            Objects.requireNonNull(subscription, "Subscription cannot be null");
            if (this.upstreamSubscription != null) {
                try {
                    subscription.cancel();
                }
                catch (Throwable t) {
                    LOG.error("Subscription violated $3.15 by throwing an exception from cancel.", t);
                }
            } else if (!this.terminated) {
                this.upstreamSubscription = subscription;
                try {
                    this.downstreamSubscriber.onSubscribe((Subscription)this);
                }
                catch (Throwable t) {
                    this.cancel();
                    LOG.error("Subscriber violated $2.13 by throwing an exception from onSubscribe.", t);
                }
            }
        }

        public void onNext(@NonNull ReactiveRow row) {
            LOG.trace("Received onNext: {}", (Object)row);
            if (this.upstreamSubscription == null) {
                LOG.error("Publisher violated $1.09 by signalling onNext prior to onSubscribe.");
            } else if (!this.terminated) {
                Object entity;
                Objects.requireNonNull(row, "Publisher violated $2.13 by emitting a null element");
                try {
                    entity = DefaultMappedReactiveResultSet.this.mapper.apply(row);
                }
                catch (Throwable t) {
                    this.onError(t);
                    return;
                }
                Objects.requireNonNull(entity, "Publisher violated $2.13 by generating a null entity");
                try {
                    this.downstreamSubscriber.onNext(entity);
                }
                catch (Throwable t) {
                    LOG.error("Subscriber violated $2.13 by throwing an exception from onNext.", t);
                    this.cancel();
                }
            }
        }

        public void onComplete() {
            LOG.trace("Received onComplete");
            if (this.upstreamSubscription == null) {
                LOG.error("Publisher violated $1.09 by signalling onComplete prior to onSubscribe.");
            } else if (!this.terminated) {
                try {
                    this.downstreamSubscriber.onComplete();
                }
                catch (Throwable t) {
                    LOG.error("Subscriber violated $2.13 by throwing an exception from onComplete.", t);
                }
                this.cancel();
            }
        }

        public void onError(@NonNull Throwable error) {
            LOG.trace("Received onError", error);
            if (this.upstreamSubscription == null) {
                LOG.error("Publisher violated $1.09 by signalling onError prior to onSubscribe.");
            } else if (!this.terminated) {
                Objects.requireNonNull(error, "Publisher violated $2.13 by signalling a null error");
                try {
                    this.downstreamSubscriber.onError(error);
                }
                catch (Throwable t) {
                    t.addSuppressed(error);
                    LOG.error("Subscriber violated $2.13 by throwing an exception from onError.", t);
                }
                this.cancel();
            }
        }

        public void request(long n) {
            LOG.trace("Received request: {}", (Object)n);
            if (!this.terminated) {
                if (n <= 0L) {
                    this.onError(new IllegalArgumentException("Subscriber violated $3.9 by requesting a non-positive number of elements."));
                } else {
                    try {
                        this.upstreamSubscription.request(n);
                    }
                    catch (Throwable t) {
                        IllegalStateException error = new IllegalStateException("Subscription violated $3.16 by throwing an exception from request.", t);
                        this.onError(error);
                    }
                }
            }
        }

        public void cancel() {
            if (!this.terminated) {
                this.terminated = true;
                LOG.trace("Cancelling");
                if (this.upstreamSubscription != null) {
                    this.upstreamSubscription.cancel();
                }
                this.downstreamSubscriber = null;
                this.upstreamSubscription = null;
            }
        }
    }
}

