/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class DefaultAggregateMetadata
implements AggregateMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAggregateMetadata.class);
    @NonNull
    private final CqlIdentifier keyspace;
    @NonNull
    private final FunctionSignature signature;
    @Nullable
    private final FunctionSignature finalFuncSignature;
    @Nullable
    private final Object initCond;
    @NonNull
    private final DataType returnType;
    @NonNull
    private final FunctionSignature stateFuncSignature;
    @NonNull
    private final DataType stateType;
    @NonNull
    private final TypeCodec<Object> stateTypeCodec;

    public DefaultAggregateMetadata(@NonNull CqlIdentifier keyspace, @NonNull FunctionSignature signature, @Nullable FunctionSignature finalFuncSignature, @Nullable Object initCond, @NonNull DataType returnType, @NonNull FunctionSignature stateFuncSignature, @NonNull DataType stateType, @NonNull TypeCodec<Object> stateTypeCodec) {
        this.keyspace = keyspace;
        this.signature = signature;
        this.finalFuncSignature = finalFuncSignature;
        this.initCond = initCond;
        this.returnType = returnType;
        this.stateFuncSignature = stateFuncSignature;
        this.stateType = stateType;
        this.stateTypeCodec = stateTypeCodec;
    }

    @Override
    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @Override
    @NonNull
    public FunctionSignature getSignature() {
        return this.signature;
    }

    @Override
    @NonNull
    public Optional<FunctionSignature> getFinalFuncSignature() {
        return Optional.ofNullable(this.finalFuncSignature);
    }

    @Override
    @NonNull
    public Optional<Object> getInitCond() {
        return Optional.ofNullable(this.initCond);
    }

    @Override
    @NonNull
    public DataType getReturnType() {
        return this.returnType;
    }

    @Override
    @NonNull
    public FunctionSignature getStateFuncSignature() {
        return this.stateFuncSignature;
    }

    @Override
    @NonNull
    public DataType getStateType() {
        return this.stateType;
    }

    @Override
    @NonNull
    public Optional<String> formatInitCond() {
        if (this.initCond == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.stateTypeCodec.format(this.initCond));
        }
        catch (Throwable t) {
            LOG.warn(String.format("Failed to format INITCOND for %s.%s, using toString instead", this.keyspace.asInternal(), this.signature.getName().asInternal()));
            return Optional.of(this.initCond.toString());
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AggregateMetadata) {
            AggregateMetadata that = (AggregateMetadata)other;
            return Objects.equals(this.keyspace, that.getKeyspace()) && Objects.equals(this.signature, that.getSignature()) && Objects.equals(this.finalFuncSignature, that.getFinalFuncSignature().orElse(null)) && Objects.equals(this.initCond, that.getInitCond().orElse(null)) && Objects.equals(this.returnType, that.getReturnType()) && Objects.equals(this.stateFuncSignature, that.getStateFuncSignature()) && Objects.equals(this.stateType, that.getStateType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.signature, this.finalFuncSignature, this.initCond, this.returnType, this.stateFuncSignature, this.stateType);
    }

    public String toString() {
        return "DefaultAggregateMetadata@" + Integer.toHexString(this.hashCode()) + "(" + this.keyspace.asInternal() + "." + this.signature + ")";
    }
}

