/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.StatementBuilder;
import com.datastax.oss.driver.internal.core.cql.DefaultSimpleStatement;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class SimpleStatementBuilder
extends StatementBuilder<SimpleStatementBuilder, SimpleStatement> {
    @NonNull
    private String query;
    @Nullable
    private CqlIdentifier keyspace;
    @Nullable
    private NullAllowingImmutableList.Builder<Object> positionalValuesBuilder;
    @Nullable
    private NullAllowingImmutableMap.Builder<CqlIdentifier, Object> namedValuesBuilder;

    public SimpleStatementBuilder(@NonNull String query) {
        this.query = query;
    }

    public SimpleStatementBuilder(@NonNull SimpleStatement template) {
        super(template);
        if (!template.getPositionalValues().isEmpty() && !template.getNamedValues().isEmpty()) {
            throw new IllegalArgumentException("Illegal statement to copy, can't have both named and positional values");
        }
        this.query = template.getQuery();
        if (!template.getPositionalValues().isEmpty()) {
            this.positionalValuesBuilder = NullAllowingImmutableList.builder((int)template.getPositionalValues().size()).addAll(template.getPositionalValues());
        }
        if (!template.getNamedValues().isEmpty()) {
            this.namedValuesBuilder = NullAllowingImmutableMap.builder((int)template.getNamedValues().size()).putAll(template.getNamedValues());
        }
    }

    @NonNull
    public SimpleStatementBuilder setQuery(@NonNull String query) {
        this.query = query;
        return this;
    }

    @NonNull
    public SimpleStatementBuilder setKeyspace(@Nullable CqlIdentifier keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    @NonNull
    public SimpleStatementBuilder setKeyspace(@Nullable String keyspaceName) {
        return this.setKeyspace(keyspaceName == null ? null : CqlIdentifier.fromCql(keyspaceName));
    }

    @NonNull
    public SimpleStatementBuilder addPositionalValue(@Nullable Object value) {
        if (this.namedValuesBuilder != null) {
            throw new IllegalArgumentException("Can't have both positional and named values in a statement.");
        }
        if (this.positionalValuesBuilder == null) {
            this.positionalValuesBuilder = NullAllowingImmutableList.builder();
        }
        this.positionalValuesBuilder.add(value);
        return this;
    }

    @NonNull
    public SimpleStatementBuilder addPositionalValues(@NonNull Iterable<Object> values) {
        if (this.namedValuesBuilder != null) {
            throw new IllegalArgumentException("Can't have both positional and named values in a statement.");
        }
        if (this.positionalValuesBuilder == null) {
            this.positionalValuesBuilder = NullAllowingImmutableList.builder();
        }
        this.positionalValuesBuilder.addAll(values);
        return this;
    }

    @NonNull
    public SimpleStatementBuilder addPositionalValues(Object ... values) {
        return this.addPositionalValues(Arrays.asList(values));
    }

    @NonNull
    public SimpleStatementBuilder clearPositionalValues() {
        this.positionalValuesBuilder = NullAllowingImmutableList.builder();
        return this;
    }

    @NonNull
    public SimpleStatementBuilder addNamedValue(@NonNull CqlIdentifier name, @Nullable Object value) {
        if (this.positionalValuesBuilder != null) {
            throw new IllegalArgumentException("Can't have both positional and named values in a statement.");
        }
        if (this.namedValuesBuilder == null) {
            this.namedValuesBuilder = NullAllowingImmutableMap.builder();
        }
        this.namedValuesBuilder.put((Object)name, value);
        return this;
    }

    @NonNull
    public SimpleStatementBuilder addNamedValue(@NonNull String name, @Nullable Object value) {
        return this.addNamedValue(CqlIdentifier.fromCql(name), value);
    }

    @NonNull
    public SimpleStatementBuilder clearNamedValues() {
        this.namedValuesBuilder = NullAllowingImmutableMap.builder();
        return this;
    }

    @Override
    @NonNull
    public SimpleStatement build() {
        return new DefaultSimpleStatement(this.query, (List<Object>)(this.positionalValuesBuilder == null ? NullAllowingImmutableList.of() : this.positionalValuesBuilder.build()), (Map<CqlIdentifier, Object>)(this.namedValuesBuilder == null ? NullAllowingImmutableMap.of() : this.namedValuesBuilder.build()), this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.buildCustomPayload(), this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node);
    }
}

