/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.schema;

import com.datastax.dse.driver.api.core.metadata.schema.DseViewMetadata;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultDseViewMetadata
implements DseViewMetadata {
    @NonNull
    private final CqlIdentifier keyspace;
    @NonNull
    private final CqlIdentifier name;
    @NonNull
    private final CqlIdentifier baseTable;
    private final boolean includesAllColumns;
    @Nullable
    private final String whereClause;
    @NonNull
    private final UUID id;
    @NonNull
    private final ImmutableList<ColumnMetadata> partitionKey;
    @NonNull
    private final ImmutableMap<ColumnMetadata, ClusteringOrder> clusteringColumns;
    @NonNull
    private final ImmutableMap<CqlIdentifier, ColumnMetadata> columns;
    @NonNull
    private final Map<CqlIdentifier, Object> options;

    public DefaultDseViewMetadata(@NonNull CqlIdentifier keyspace, @NonNull CqlIdentifier name, @NonNull CqlIdentifier baseTable, boolean includesAllColumns, @Nullable String whereClause, @NonNull UUID id, @NonNull ImmutableList<ColumnMetadata> partitionKey, @NonNull ImmutableMap<ColumnMetadata, ClusteringOrder> clusteringColumns, @NonNull ImmutableMap<CqlIdentifier, ColumnMetadata> columns, @NonNull Map<CqlIdentifier, Object> options) {
        this.keyspace = keyspace;
        this.name = name;
        this.baseTable = baseTable;
        this.includesAllColumns = includesAllColumns;
        this.whereClause = whereClause;
        this.id = id;
        this.partitionKey = partitionKey;
        this.clusteringColumns = clusteringColumns;
        this.columns = columns;
        this.options = options;
    }

    @Override
    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @Override
    @NonNull
    public CqlIdentifier getName() {
        return this.name;
    }

    @Override
    @NonNull
    public Optional<UUID> getId() {
        return Optional.of(this.id);
    }

    @Override
    @NonNull
    public CqlIdentifier getBaseTable() {
        return this.baseTable;
    }

    @Override
    public boolean includesAllColumns() {
        return this.includesAllColumns;
    }

    @Override
    @NonNull
    public Optional<String> getWhereClause() {
        return Optional.ofNullable(this.whereClause);
    }

    @Override
    @NonNull
    public List<ColumnMetadata> getPartitionKey() {
        return this.partitionKey;
    }

    @Override
    @NonNull
    public Map<ColumnMetadata, ClusteringOrder> getClusteringColumns() {
        return this.clusteringColumns;
    }

    @Override
    @NonNull
    public Map<CqlIdentifier, ColumnMetadata> getColumns() {
        return this.columns;
    }

    @Override
    @NonNull
    public Map<CqlIdentifier, Object> getOptions() {
        return this.options;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DseViewMetadata) {
            DseViewMetadata that = (DseViewMetadata)other;
            return Objects.equals(this.keyspace, that.getKeyspace()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.baseTable, that.getBaseTable()) && this.includesAllColumns == that.includesAllColumns() && Objects.equals(this.whereClause, that.getWhereClause().orElse(null)) && Objects.equals(Optional.of(this.id), that.getId()) && Objects.equals(this.partitionKey, that.getPartitionKey()) && Objects.equals(this.clusteringColumns, that.getClusteringColumns()) && Objects.equals(this.columns, that.getColumns()) && Objects.equals(this.options, that.getOptions());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.keyspace, this.name, this.baseTable, this.includesAllColumns, this.whereClause, this.id, this.partitionKey, this.clusteringColumns, this.columns, this.options);
    }
}

