/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.reactive;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.dse.driver.api.core.cql.reactive.ReactiveRow;
import com.datastax.dse.driver.internal.core.cql.reactive.EmptySubscription;
import com.datastax.dse.driver.internal.core.cql.reactive.ReactiveResultSetSubscription;
import com.datastax.dse.driver.internal.core.cql.reactive.SimpleUnicastProcessor;
import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@ThreadSafe
public abstract class ReactiveResultSetBase<ResultSetT extends AsyncPagingIterable<Row, ResultSetT>>
implements ReactiveResultSet {
    private final Callable<CompletionStage<ResultSetT>> firstPage;
    private final AtomicBoolean once = new AtomicBoolean(false);
    private final SimpleUnicastProcessor<ColumnDefinitions> columnDefinitionsPublisher = new SimpleUnicastProcessor();
    private final SimpleUnicastProcessor<ExecutionInfo> executionInfosPublisher = new SimpleUnicastProcessor();
    private final SimpleUnicastProcessor<Boolean> wasAppliedPublisher = new SimpleUnicastProcessor();

    protected ReactiveResultSetBase(Callable<CompletionStage<ResultSetT>> firstPage) {
        this.firstPage = firstPage;
    }

    public void subscribe(@NonNull Subscriber<? super ReactiveRow> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber cannot be null");
        if (this.once.compareAndSet(false, true)) {
            ReactiveResultSetSubscription<ResultSetT> subscription = new ReactiveResultSetSubscription<ResultSetT>((Subscriber<ReactiveRow>)subscriber, (Subscriber<ColumnDefinitions>)this.columnDefinitionsPublisher, (Subscriber<ExecutionInfo>)this.executionInfosPublisher, (Subscriber<Boolean>)this.wasAppliedPublisher);
            try {
                subscriber.onSubscribe(subscription);
                subscription.start(this.firstPage);
            }
            catch (Throwable t) {
                subscription.doOnError(new IllegalStateException(subscriber + " violated the Reactive Streams rule 2.13 by throwing an exception from onSubscribe.", t));
            }
        } else {
            subscriber.onSubscribe((Subscription)EmptySubscription.INSTANCE);
            subscriber.onError((Throwable)new IllegalStateException("This publisher does not support multiple subscriptions"));
        }
    }

    @Override
    @NonNull
    public Publisher<? extends ColumnDefinitions> getColumnDefinitions() {
        return this.columnDefinitionsPublisher;
    }

    @Override
    @NonNull
    public Publisher<? extends ExecutionInfo> getExecutionInfos() {
        return this.executionInfosPublisher;
    }

    @Override
    @NonNull
    public Publisher<Boolean> wasApplied() {
        return this.wasAppliedPublisher;
    }
}

