/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.graph;

import com.datastax.dse.driver.api.core.graph.GraphStatementBuilderBase;
import com.datastax.dse.driver.api.core.graph.ScriptGraphStatement;
import com.datastax.dse.driver.internal.core.graph.DefaultScriptGraphStatement;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class ScriptGraphStatementBuilder
extends GraphStatementBuilderBase<ScriptGraphStatementBuilder, ScriptGraphStatement> {
    private String script;
    private Boolean isSystemQuery;
    private Map<String, Object> queryParams;

    public ScriptGraphStatementBuilder(String script) {
        this.script = script;
        this.queryParams = Maps.newHashMap();
    }

    public ScriptGraphStatementBuilder(ScriptGraphStatement template) {
        super(template);
        this.script = template.getScript();
        this.queryParams = Maps.newHashMap(template.getQueryParams());
        this.isSystemQuery = template.isSystemQuery();
    }

    @NonNull
    public ScriptGraphStatementBuilder setSystemQuery(@Nullable Boolean isSystemQuery) {
        this.isSystemQuery = isSystemQuery;
        return this;
    }

    @NonNull
    public ScriptGraphStatementBuilder setQueryParam(@NonNull String name, @Nullable Object value) {
        this.queryParams.put(name, value);
        return this;
    }

    @NonNull
    public ScriptGraphStatementBuilder setQueryParams(@NonNull Map<String, Object> params) {
        this.queryParams.putAll(params);
        return this;
    }

    @NonNull
    public ScriptGraphStatementBuilder removeQueryParam(@NonNull String name) {
        this.queryParams.remove(name);
        return this;
    }

    public ScriptGraphStatementBuilder clearQueryParams() {
        this.queryParams.clear();
        return this;
    }

    @Override
    @NonNull
    public ScriptGraphStatement build() {
        return new DefaultScriptGraphStatement(this.script, this.queryParams, this.isSystemQuery, this.isIdempotent, this.timeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, this.buildCustomPayload(), this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }
}

