/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.auth;

import com.datastax.dse.driver.api.core.auth.BaseDseAuthenticator;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.auth.Authenticator;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class DseGssApiAuthProviderBase
implements AuthProvider {
    public static final String DEFAULT_SASL_SERVICE_NAME = "dse";
    public static final String SASL_SERVICE_NAME_PROPERTY = "dse.sasl.service";
    private static final String LEGACY_SASL_PROTOCOL_PROPERTY = "dse.sasl.protocol";
    private static final Logger LOG = LoggerFactory.getLogger(DseGssApiAuthProviderBase.class);
    private final String logPrefix;

    protected DseGssApiAuthProviderBase(@NonNull String logPrefix) {
        this.logPrefix = Objects.requireNonNull(logPrefix);
    }

    @NonNull
    protected abstract GssApiOptions getOptions(@NonNull EndPoint var1, @NonNull String var2);

    @Override
    @NonNull
    public Authenticator newAuthenticator(@NonNull EndPoint endPoint, @NonNull String serverAuthenticator) throws AuthenticationException {
        return new GssApiAuthenticator(this.getOptions(endPoint, serverAuthenticator), endPoint, serverAuthenticator);
    }

    @Override
    public void onMissingChallenge(@NonNull EndPoint endPoint) {
        LOG.warn("[{}] {} did not send an authentication challenge; This is suspicious because the driver expects authentication", (Object)this.logPrefix, (Object)endPoint);
    }

    @Override
    public void close() {
    }

    protected static class GssApiAuthenticator
    extends BaseDseAuthenticator {
        private static final ByteBuffer MECHANISM = ByteBuffer.wrap("GSSAPI".getBytes(Charsets.UTF_8)).asReadOnlyBuffer();
        private static final ByteBuffer SERVER_INITIAL_CHALLENGE = ByteBuffer.wrap("GSSAPI-START".getBytes(Charsets.UTF_8)).asReadOnlyBuffer();
        private static final ByteBuffer EMPTY_BYTE_ARRAY = ByteBuffer.wrap(new byte[0]).asReadOnlyBuffer();
        private static final String JAAS_CONFIG_ENTRY = "DseClient";
        private static final String[] SUPPORTED_MECHANISMS = new String[]{"GSSAPI"};
        private Subject subject;
        private SaslClient saslClient;
        private EndPoint endPoint;

        protected GssApiAuthenticator(GssApiOptions options, EndPoint endPoint, String serverAuthenticator) {
            super(serverAuthenticator);
            try {
                if (options.getSubject() != null) {
                    this.subject = options.getSubject();
                } else {
                    Configuration loginConfiguration = options.getLoginConfiguration();
                    if (loginConfiguration == null) {
                        throw new IllegalArgumentException("Must provide one of subject or loginConfiguration");
                    }
                    LoginContext login = new LoginContext(JAAS_CONFIG_ENTRY, null, null, loginConfiguration);
                    login.login();
                    this.subject = login.getSubject();
                }
                String protocol = options.getSaslProtocol();
                if (protocol == null) {
                    protocol = System.getProperty(DseGssApiAuthProviderBase.SASL_SERVICE_NAME_PROPERTY, System.getProperty(DseGssApiAuthProviderBase.LEGACY_SASL_PROTOCOL_PROPERTY, DseGssApiAuthProviderBase.DEFAULT_SASL_SERVICE_NAME));
                }
                this.saslClient = Sasl.createSaslClient(SUPPORTED_MECHANISMS, options.getAuthorizationId(), protocol, ((InetSocketAddress)endPoint.resolve()).getAddress().getCanonicalHostName(), options.getSaslProperties(), null);
            }
            catch (LoginException | SaslException e) {
                throw new AuthenticationException(endPoint, e.getMessage());
            }
            this.endPoint = endPoint;
        }

        @Override
        @NonNull
        protected ByteBuffer getMechanism() {
            return MECHANISM;
        }

        @Override
        @NonNull
        protected ByteBuffer getInitialServerChallenge() {
            return SERVER_INITIAL_CHALLENGE;
        }

        @Override
        @Nullable
        public ByteBuffer evaluateChallengeSync(@Nullable ByteBuffer challenge) {
            byte[] challengeBytes;
            if (SERVER_INITIAL_CHALLENGE.equals(challenge)) {
                if (!this.saslClient.hasInitialResponse()) {
                    return EMPTY_BYTE_ARRAY;
                }
                challengeBytes = new byte[]{};
            } else {
                if (challenge == null) {
                    throw new AuthenticationException(this.endPoint, "Unexpected null challenge from server");
                }
                challengeBytes = Bytes.getArray((ByteBuffer)challenge);
            }
            try {
                return ByteBuffer.wrap(Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws SaslException {
                        return saslClient.evaluateChallenge(challengeBytes);
                    }
                }));
            }
            catch (PrivilegedActionException e) {
                throw new AuthenticationException(this.endPoint, e.getMessage(), e.getException());
            }
        }
    }

    @Immutable
    public static class GssApiOptions {
        private final Configuration loginConfiguration;
        private final Subject subject;
        private final String saslProtocol;
        private final String authorizationId;
        private final Map<String, String> saslProperties;

        @NonNull
        public static Builder builder() {
            return new Builder();
        }

        private GssApiOptions(@Nullable Configuration loginConfiguration, @Nullable Subject subject, @Nullable String saslProtocol, @Nullable String authorizationId, @NonNull Map<String, String> saslProperties) {
            this.loginConfiguration = loginConfiguration;
            this.subject = subject;
            this.saslProtocol = saslProtocol;
            this.authorizationId = authorizationId;
            this.saslProperties = saslProperties;
        }

        @Nullable
        public Configuration getLoginConfiguration() {
            return this.loginConfiguration;
        }

        @Nullable
        public Subject getSubject() {
            return this.subject;
        }

        @Nullable
        public String getSaslProtocol() {
            return this.saslProtocol;
        }

        @Nullable
        public String getAuthorizationId() {
            return this.authorizationId;
        }

        @NonNull
        public Map<String, String> getSaslProperties() {
            return this.saslProperties;
        }

        @NotThreadSafe
        public static class Builder {
            private Configuration loginConfiguration;
            private Subject subject;
            private String saslProtocol;
            private String authorizationId;
            private final Map<String, String> saslProperties = new HashMap<String, String>();

            public Builder() {
                this.saslProperties.put("javax.security.sasl.server.authentication", "true");
                this.saslProperties.put("javax.security.sasl.qop", "auth");
            }

            @NonNull
            public Builder withLoginConfiguration(@Nullable Configuration loginConfiguration) {
                this.loginConfiguration = loginConfiguration;
                return this;
            }

            @NonNull
            public Builder withSubject(@Nullable Subject subject) {
                this.subject = subject;
                return this;
            }

            @NonNull
            public Builder withSaslProtocol(@Nullable String saslProtocol) {
                this.saslProtocol = saslProtocol;
                return this;
            }

            @NonNull
            public Builder withAuthorizationId(@Nullable String authorizationId) {
                this.authorizationId = authorizationId;
                return this;
            }

            @NonNull
            public Builder addSaslProperty(@NonNull String name, @NonNull String value) {
                this.saslProperties.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
                return this;
            }

            @NonNull
            public GssApiOptions build() {
                return new GssApiOptions(this.loginConfiguration, this.subject, this.saslProtocol, this.authorizationId, (Map)ImmutableMap.copyOf(this.saslProperties));
            }
        }
    }
}

