/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.servererrors;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.QueryConsistencyException;
import edu.umd.cs.findbugs.annotations.NonNull;

public class ReadTimeoutException
extends QueryConsistencyException {
    private final boolean dataPresent;

    public ReadTimeoutException(@NonNull Node coordinator, @NonNull ConsistencyLevel consistencyLevel, int received, int blockFor, boolean dataPresent) {
        this(coordinator, String.format("Cassandra timeout during read query at consistency %s (%s)", consistencyLevel, ReadTimeoutException.formatDetails(received, blockFor, dataPresent)), consistencyLevel, received, blockFor, dataPresent, null, false);
    }

    private ReadTimeoutException(@NonNull Node coordinator, @NonNull String message, @NonNull ConsistencyLevel consistencyLevel, int received, int blockFor, boolean dataPresent, ExecutionInfo executionInfo, boolean writableStackTrace) {
        super(coordinator, message, consistencyLevel, received, blockFor, executionInfo, writableStackTrace);
        this.dataPresent = dataPresent;
    }

    private static String formatDetails(int received, int blockFor, boolean dataPresent) {
        if (received < blockFor) {
            return String.format("%d responses were required but only %d replica responded", blockFor, received);
        }
        if (!dataPresent) {
            return "the replica queried for data didn't respond";
        }
        return "timeout while waiting for repair of inconsistent replica";
    }

    public boolean wasDataPresent() {
        return this.dataPresent;
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new ReadTimeoutException(this.getCoordinator(), this.getMessage(), this.getConsistencyLevel(), this.getReceived(), this.getBlockFor(), this.dataPresent, this.getExecutionInfo(), true);
    }
}

