/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.registry;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.CustomType;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.CodecNotFoundException;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.reflect.TypeToken;
import com.datastax.oss.protocol.internal.util.IntMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class CachingCodecRegistry
implements CodecRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CachingCodecRegistry.class);
    protected final String logPrefix;
    private final TypeCodec<?>[] primitiveCodecs;
    private final TypeCodec<?>[] userCodecs;
    private final IntMap<TypeCodec> primitiveCodecsByCode;

    protected CachingCodecRegistry(String logPrefix, TypeCodec<?>[] primitiveCodecs, TypeCodec<?>[] userCodecs) {
        this.logPrefix = logPrefix;
        this.primitiveCodecs = primitiveCodecs;
        this.userCodecs = userCodecs;
        this.primitiveCodecsByCode = CachingCodecRegistry.sortByProtocolCode(primitiveCodecs);
    }

    protected abstract TypeCodec<?> getCachedCodec(DataType var1, GenericType<?> var2, boolean var3);

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull DataType cqlType, @NonNull GenericType<JavaTypeT> javaType) {
        return this.codecFor(cqlType, javaType, false);
    }

    protected <JavaTypeT> TypeCodec<JavaTypeT> codecFor(DataType cqlType, GenericType<JavaTypeT> javaType, boolean isJavaCovariant) {
        LOG.trace("[{}] Looking up codec for {} <-> {}", new Object[]{this.logPrefix, cqlType, javaType});
        TypeCodec primitiveCodec = (TypeCodec)this.primitiveCodecsByCode.get(cqlType.getProtocolCode());
        if (primitiveCodec != null && this.matches(primitiveCodec, javaType, isJavaCovariant)) {
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, (Object)primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec<?> userCodec : this.userCodecs) {
            if (!userCodec.accepts(cqlType) || !this.matches(userCodec, javaType, isJavaCovariant)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, userCodec);
            return CachingCodecRegistry.uncheckedCast(userCodec);
        }
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(cqlType, javaType, isJavaCovariant));
    }

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull DataType cqlType, @NonNull Class<JavaTypeT> javaType) {
        LOG.trace("[{}] Looking up codec for {} <-> {}", new Object[]{this.logPrefix, cqlType, javaType});
        TypeCodec primitiveCodec = (TypeCodec)this.primitiveCodecsByCode.get(cqlType.getProtocolCode());
        if (primitiveCodec != null && primitiveCodec.accepts(javaType)) {
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, (Object)primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec<JavaTypeT> typeCodec : this.userCodecs) {
            if (!typeCodec.accepts(cqlType) || !typeCodec.accepts(javaType)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, typeCodec);
            return CachingCodecRegistry.uncheckedCast(typeCodec);
        }
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(cqlType, GenericType.of(javaType), false));
    }

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull DataType cqlType) {
        LOG.trace("[{}] Looking up codec for CQL type {}", (Object)this.logPrefix, (Object)cqlType);
        TypeCodec primitiveCodec = (TypeCodec)this.primitiveCodecsByCode.get(cqlType.getProtocolCode());
        if (primitiveCodec != null) {
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, (Object)primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec<?> userCodec : this.userCodecs) {
            if (!userCodec.accepts(cqlType)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, userCodec);
            return CachingCodecRegistry.uncheckedCast(userCodec);
        }
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(cqlType, null, false));
    }

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull DataType cqlType, @NonNull JavaTypeT value) {
        Preconditions.checkNotNull((Object)cqlType);
        Preconditions.checkNotNull(value);
        LOG.trace("[{}] Looking up codec for CQL type {} and object {}", new Object[]{this.logPrefix, cqlType, value});
        TypeCodec primitiveCodec = (TypeCodec)this.primitiveCodecsByCode.get(cqlType.getProtocolCode());
        if (primitiveCodec != null && primitiveCodec.accepts(value)) {
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, (Object)primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec<?> userCodec : this.userCodecs) {
            if (!userCodec.accepts(cqlType) || !userCodec.accepts(value)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, userCodec);
            return CachingCodecRegistry.uncheckedCast(userCodec);
        }
        if (value instanceof TupleValue) {
            return CachingCodecRegistry.uncheckedCast(this.codecFor(cqlType, (JavaTypeT)TupleValue.class));
        }
        if (value instanceof UdtValue) {
            return CachingCodecRegistry.uncheckedCast(this.codecFor(cqlType, (JavaTypeT)UdtValue.class));
        }
        GenericType<?> javaType = this.inspectType(value);
        LOG.trace("[{}] Continuing based on inferred type {}", (Object)this.logPrefix, javaType);
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(cqlType, javaType, true));
    }

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull JavaTypeT value) {
        Preconditions.checkNotNull(value);
        LOG.trace("[{}] Looking up codec for object {}", (Object)this.logPrefix, value);
        for (TypeCodec<?> primitiveCodec : this.primitiveCodecs) {
            if (!primitiveCodec.accepts(value)) continue;
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec<?> userCodec : this.userCodecs) {
            if (!userCodec.accepts(value)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, userCodec);
            return CachingCodecRegistry.uncheckedCast(userCodec);
        }
        if (value instanceof TupleValue) {
            return CachingCodecRegistry.uncheckedCast(this.codecFor((DataType)((TupleValue)value).getType(), (JavaTypeT)TupleValue.class));
        }
        if (value instanceof UdtValue) {
            return CachingCodecRegistry.uncheckedCast(this.codecFor((DataType)((UdtValue)value).getType(), (JavaTypeT)UdtValue.class));
        }
        GenericType<?> javaType = this.inspectType(value);
        LOG.trace("[{}] Continuing based on inferred type {}", (Object)this.logPrefix, javaType);
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(null, javaType, true));
    }

    @Override
    @NonNull
    public <JavaTypeT> TypeCodec<JavaTypeT> codecFor(@NonNull GenericType<JavaTypeT> javaType) {
        return this.codecFor(javaType, false);
    }

    protected <JavaTypeT> TypeCodec<JavaTypeT> codecFor(GenericType<JavaTypeT> javaType, boolean isJavaCovariant) {
        LOG.trace("[{}] Looking up codec for Java type {} (covariant = {})", new Object[]{this.logPrefix, javaType, isJavaCovariant});
        for (TypeCodec<?> primitiveCodec : this.primitiveCodecs) {
            if (!this.matches(primitiveCodec, javaType, isJavaCovariant)) continue;
            LOG.trace("[{}] Found matching primitive codec {}", (Object)this.logPrefix, primitiveCodec);
            return CachingCodecRegistry.uncheckedCast(primitiveCodec);
        }
        for (TypeCodec<?> userCodec : this.userCodecs) {
            if (!this.matches(userCodec, javaType, isJavaCovariant)) continue;
            LOG.trace("[{}] Found matching user codec {}", (Object)this.logPrefix, userCodec);
            return CachingCodecRegistry.uncheckedCast(userCodec);
        }
        return CachingCodecRegistry.uncheckedCast(this.getCachedCodec(null, javaType, isJavaCovariant));
    }

    protected boolean matches(TypeCodec<?> codec, GenericType<?> javaType, boolean isJavaCovariant) {
        return isJavaCovariant ? codec.getJavaType().isSupertypeOf(javaType) : codec.accepts(javaType);
    }

    protected GenericType<?> inspectType(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return GenericType.listOf(Boolean.class);
            }
            GenericType<?> elementType = this.inspectType(list.get(0));
            return GenericType.listOf(elementType);
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            if (set.isEmpty()) {
                return GenericType.setOf(Boolean.class);
            }
            GenericType<?> elementType = this.inspectType(set.iterator().next());
            return GenericType.setOf(elementType);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                return GenericType.mapOf(Boolean.class, Boolean.class);
            }
            Map.Entry entry = map.entrySet().iterator().next();
            GenericType<?> keyType = this.inspectType(entry.getKey());
            GenericType<?> valueType = this.inspectType(entry.getValue());
            return GenericType.mapOf(keyType, valueType);
        }
        return GenericType.of(value.getClass());
    }

    protected TypeCodec<?> createCodec(DataType cqlType, GenericType<?> javaType, boolean isJavaCovariant) {
        LOG.trace("[{}] Cache miss, creating codec", (Object)this.logPrefix);
        if (javaType == null) {
            assert (cqlType != null);
            return this.createCodec(cqlType);
        }
        if (cqlType == null) {
            return this.createCodec(javaType, isJavaCovariant);
        }
        TypeToken<?> token = javaType.__getToken();
        if (cqlType instanceof ListType && List.class.isAssignableFrom(token.getRawType())) {
            TypeCodec<DataType> elementCodec;
            DataType elementCqlType = ((ListType)cqlType).getElementType();
            if (token.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
                GenericType<?> elementJavaType = GenericType.of(typeArguments[0]);
                elementCodec = CachingCodecRegistry.uncheckedCast(this.codecFor(elementCqlType, elementJavaType, isJavaCovariant));
            } else {
                elementCodec = this.codecFor((Object)elementCqlType);
            }
            return TypeCodecs.listOf(elementCodec);
        }
        if (cqlType instanceof SetType && Set.class.isAssignableFrom(token.getRawType())) {
            TypeCodec<DataType> elementCodec;
            DataType elementCqlType = ((SetType)cqlType).getElementType();
            if (token.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
                GenericType<?> elementJavaType = GenericType.of(typeArguments[0]);
                elementCodec = CachingCodecRegistry.uncheckedCast(this.codecFor(elementCqlType, elementJavaType, isJavaCovariant));
            } else {
                elementCodec = this.codecFor((Object)elementCqlType);
            }
            return TypeCodecs.setOf(elementCodec);
        }
        if (cqlType instanceof MapType && Map.class.isAssignableFrom(token.getRawType())) {
            TypeCodec<DataType> valueCodec;
            TypeCodec<DataType> keyCodec;
            DataType keyCqlType = ((MapType)cqlType).getKeyType();
            DataType valueCqlType = ((MapType)cqlType).getValueType();
            if (token.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
                GenericType<?> keyJavaType = GenericType.of(typeArguments[0]);
                GenericType<?> valueJavaType = GenericType.of(typeArguments[1]);
                keyCodec = CachingCodecRegistry.uncheckedCast(this.codecFor(keyCqlType, keyJavaType, isJavaCovariant));
                valueCodec = CachingCodecRegistry.uncheckedCast(this.codecFor(valueCqlType, valueJavaType, isJavaCovariant));
            } else {
                keyCodec = this.codecFor((Object)keyCqlType);
                valueCodec = this.codecFor((Object)valueCqlType);
            }
            return TypeCodecs.mapOf(keyCodec, valueCodec);
        }
        if (cqlType instanceof TupleType && TupleValue.class.isAssignableFrom(token.getRawType())) {
            return TypeCodecs.tupleOf((TupleType)cqlType);
        }
        if (cqlType instanceof UserDefinedType && UdtValue.class.isAssignableFrom(token.getRawType())) {
            return TypeCodecs.udtOf((UserDefinedType)cqlType);
        }
        if (cqlType instanceof CustomType && ByteBuffer.class.isAssignableFrom(token.getRawType())) {
            return TypeCodecs.custom(cqlType);
        }
        throw new CodecNotFoundException(cqlType, javaType);
    }

    protected TypeCodec<?> createCodec(GenericType<?> javaType, boolean isJavaCovariant) {
        TypeToken<?> token = javaType.__getToken();
        if (List.class.isAssignableFrom(token.getRawType()) && token.getType() instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
            GenericType<?> elementType = GenericType.of(typeArguments[0]);
            TypeCodec<?> elementCodec = this.codecFor(elementType, isJavaCovariant);
            return TypeCodecs.listOf(elementCodec);
        }
        if (Set.class.isAssignableFrom(token.getRawType()) && token.getType() instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
            GenericType<?> elementType = GenericType.of(typeArguments[0]);
            TypeCodec<?> elementCodec = this.codecFor(elementType, isJavaCovariant);
            return TypeCodecs.setOf(elementCodec);
        }
        if (Map.class.isAssignableFrom(token.getRawType()) && token.getType() instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)token.getType()).getActualTypeArguments();
            GenericType<?> keyType = GenericType.of(typeArguments[0]);
            GenericType<?> valueType = GenericType.of(typeArguments[1]);
            TypeCodec<?> keyCodec = this.codecFor(keyType, isJavaCovariant);
            TypeCodec<?> valueCodec = this.codecFor(valueType, isJavaCovariant);
            return TypeCodecs.mapOf(keyCodec, valueCodec);
        }
        throw new CodecNotFoundException(null, javaType);
    }

    protected TypeCodec<?> createCodec(DataType cqlType) {
        if (cqlType instanceof ListType) {
            DataType elementType = ((ListType)cqlType).getElementType();
            TypeCodec<DataType> elementCodec = this.codecFor((Object)elementType);
            return TypeCodecs.listOf(elementCodec);
        }
        if (cqlType instanceof SetType) {
            DataType elementType = ((SetType)cqlType).getElementType();
            TypeCodec<DataType> elementCodec = this.codecFor((Object)elementType);
            return TypeCodecs.setOf(elementCodec);
        }
        if (cqlType instanceof MapType) {
            DataType keyType = ((MapType)cqlType).getKeyType();
            DataType valueType = ((MapType)cqlType).getValueType();
            TypeCodec<DataType> keyCodec = this.codecFor((Object)keyType);
            TypeCodec<DataType> valueCodec = this.codecFor((Object)valueType);
            return TypeCodecs.mapOf(keyCodec, valueCodec);
        }
        if (cqlType instanceof TupleType) {
            return TypeCodecs.tupleOf((TupleType)cqlType);
        }
        if (cqlType instanceof UserDefinedType) {
            return TypeCodecs.udtOf((UserDefinedType)cqlType);
        }
        if (cqlType instanceof CustomType) {
            return TypeCodecs.custom(cqlType);
        }
        throw new CodecNotFoundException(cqlType, null);
    }

    private static IntMap<TypeCodec> sortByProtocolCode(TypeCodec<?>[] codecs) {
        IntMap.Builder builder = IntMap.builder();
        for (TypeCodec<?> codec : codecs) {
            builder.put(codec.getCqlType().getProtocolCode(), codec);
        }
        return builder.build();
    }

    private static <DeclaredT, RuntimeT> TypeCodec<DeclaredT> uncheckedCast(TypeCodec<RuntimeT> codec) {
        TypeCodec<RuntimeT> result = codec;
        return result;
    }
}

