/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.pool;

import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class ChannelSet
implements Iterable<DriverChannel> {
    private volatile DriverChannel[] channels;
    private final ReentrantLock lock = new ReentrantLock();

    ChannelSet() {
        this.channels = new DriverChannel[0];
    }

    void add(DriverChannel toAdd) {
        Preconditions.checkNotNull((Object)toAdd);
        this.lock.lock();
        try {
            assert (ChannelSet.indexOf(this.channels, toAdd) < 0);
            DriverChannel[] newChannels = Arrays.copyOf(this.channels, this.channels.length + 1);
            newChannels[newChannels.length - 1] = toAdd;
            this.channels = newChannels;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(DriverChannel toRemove) {
        Preconditions.checkNotNull((Object)toRemove);
        this.lock.lock();
        try {
            int index = ChannelSet.indexOf(this.channels, toRemove);
            if (index < 0) {
                boolean bl = false;
                return bl;
            }
            DriverChannel[] newChannels = new DriverChannel[this.channels.length - 1];
            int newI = 0;
            for (int i = 0; i < this.channels.length; ++i) {
                if (i == index) continue;
                newChannels[newI] = this.channels[i];
                ++newI;
            }
            this.channels = newChannels;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    DriverChannel next() {
        DriverChannel[] snapshot = this.channels;
        switch (snapshot.length) {
            case 0: {
                return null;
            }
            case 1: {
                return snapshot[0];
            }
        }
        DriverChannel best = null;
        int bestScore = 0;
        for (DriverChannel channel : snapshot) {
            int score = channel.getAvailableIds();
            if (score <= bestScore) continue;
            bestScore = score;
            best = channel;
        }
        return best;
    }

    int getAvailableIds() {
        DriverChannel[] snapshot;
        int availableIds = 0;
        for (DriverChannel channel : snapshot = this.channels) {
            availableIds += channel.getAvailableIds();
        }
        return availableIds;
    }

    int getInFlight() {
        DriverChannel[] snapshot;
        int inFlight = 0;
        for (DriverChannel channel : snapshot = this.channels) {
            inFlight += channel.getInFlight();
        }
        return inFlight;
    }

    int getOrphanedIds() {
        DriverChannel[] snapshot;
        int orphanedIds = 0;
        for (DriverChannel channel : snapshot = this.channels) {
            orphanedIds += channel.getOrphanedIds();
        }
        return orphanedIds;
    }

    int size() {
        return this.channels.length;
    }

    @Override
    @NonNull
    public Iterator<DriverChannel> iterator() {
        return Iterators.forArray((Object[])this.channels);
    }

    private static int indexOf(DriverChannel[] channels, DriverChannel key) {
        for (int i = 0; i < channels.length; ++i) {
            if (channels[i] != key) continue;
            return i;
        }
        return -1;
    }
}

