/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategy;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSetMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.SetMultimap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class SimpleReplicationStrategy
implements ReplicationStrategy {
    private final int replicationFactor;

    SimpleReplicationStrategy(Map<String, String> replicationConfig) {
        this(SimpleReplicationStrategy.extractReplicationFactor(replicationConfig));
    }

    @VisibleForTesting
    SimpleReplicationStrategy(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    @Override
    public SetMultimap<Token, Node> computeReplicasByToken(Map<Token, Node> tokenToPrimary, List<Token> ring) {
        int rf = Math.min(this.replicationFactor, ring.size());
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (int i = 0; i < ring.size(); ++i) {
            LinkedHashSet<Node> replicas = new LinkedHashSet<Node>();
            for (int j = 0; j < ring.size() && replicas.size() < rf; ++j) {
                replicas.add(tokenToPrimary.get(SimpleReplicationStrategy.getTokenWrapping(i + j, ring)));
            }
            result.putAll((Object)ring.get(i), replicas);
        }
        return result.build();
    }

    private static Token getTokenWrapping(int i, List<Token> ring) {
        return ring.get(i % ring.size());
    }

    private static int extractReplicationFactor(Map<String, String> replicationConfig) {
        String factorString = replicationConfig.get("replication_factor");
        Preconditions.checkNotNull((Object)factorString, (Object)("Missing replication factor in " + replicationConfig));
        return Integer.parseInt(factorString);
    }
}

