/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategy;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSetMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.SetMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class NetworkTopologyReplicationStrategy
implements ReplicationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkTopologyReplicationStrategy.class);
    private final Map<String, String> replicationConfig;
    private final Map<String, Integer> replicationFactors;
    private final String logPrefix;

    NetworkTopologyReplicationStrategy(Map<String, String> replicationConfig, String logPrefix) {
        this.replicationConfig = replicationConfig;
        ImmutableMap.Builder factorsBuilder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : replicationConfig.entrySet()) {
            if (entry.getKey().equals("class")) continue;
            factorsBuilder.put((Object)entry.getKey(), (Object)Integer.parseInt(entry.getValue()));
        }
        this.replicationFactors = factorsBuilder.build();
        this.logPrefix = logPrefix;
    }

    @Override
    public SetMultimap<Token, Node> computeReplicasByToken(Map<Token, Node> tokenToPrimary, List<Token> ring) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        Map<String, Set<String>> racks = this.getRacksInDcs(tokenToPrimary.values());
        HashMap dcNodeCount = Maps.newHashMapWithExpectedSize((int)this.replicationFactors.size());
        HashSet warnedDcs = Sets.newHashSetWithExpectedSize((int)this.replicationFactors.size());
        for (Node node : Sets.newHashSet(tokenToPrimary.values())) {
            String dc = node.getDatacenter();
            dcNodeCount.putIfAbsent(dc, 0);
            dcNodeCount.put(dc, (Integer)dcNodeCount.get(dc) + 1);
        }
        for (int i = 0; i < ring.size(); ++i) {
            HashMap<String, Set<Node>> allDcReplicas = new HashMap<String, Set<Node>>();
            HashMap seenRacks = new HashMap();
            HashMap skippedDcEndpoints = new HashMap();
            for (String dc : this.replicationFactors.keySet()) {
                allDcReplicas.put(dc, new HashSet());
                seenRacks.put(dc, new HashSet());
                skippedDcEndpoints.put(dc, new LinkedHashSet());
            }
            LinkedHashSet<Node> replicas = new LinkedHashSet<Node>();
            for (int j = 0; j < ring.size() && !this.allDone(allDcReplicas, dcNodeCount); ++j) {
                Node h = tokenToPrimary.get(NetworkTopologyReplicationStrategy.getTokenWrapping(i + j, ring));
                String dc = h.getDatacenter();
                if (dc == null || !allDcReplicas.containsKey(dc)) continue;
                Integer rf = this.replicationFactors.get(dc);
                Set dcReplicas = (Set)allDcReplicas.get(dc);
                if (rf == null || dcReplicas.size() >= rf) continue;
                String rack = h.getRack();
                if (rack == null || ((Set)seenRacks.get(dc)).size() == racks.get(dc).size()) {
                    replicas.add(h);
                    dcReplicas.add(h);
                    continue;
                }
                if (((Set)seenRacks.get(dc)).contains(rack)) {
                    ((Set)skippedDcEndpoints.get(dc)).add(h);
                    continue;
                }
                replicas.add(h);
                dcReplicas.add(h);
                ((Set)seenRacks.get(dc)).add(rack);
                if (((Set)seenRacks.get(dc)).size() != racks.get(dc).size()) continue;
                Iterator skippedIt = ((Set)skippedDcEndpoints.get(dc)).iterator();
                while (skippedIt.hasNext() && dcReplicas.size() < rf) {
                    Node nextSkipped = (Node)skippedIt.next();
                    replicas.add(nextSkipped);
                    dcReplicas.add(nextSkipped);
                }
            }
            for (Map.Entry entry : allDcReplicas.entrySet()) {
                String dcName = (String)entry.getKey();
                int expectedFactor = this.replicationFactors.get(dcName);
                int achievedFactor = ((Set)entry.getValue()).size();
                if (achievedFactor >= expectedFactor || warnedDcs.contains(dcName)) continue;
                LOG.warn("[{}] Error while computing token map for replication settings {}: could not achieve replication factor {} for datacenter {} (found only {} replicas).", new Object[]{this.logPrefix, this.replicationConfig, expectedFactor, dcName, achievedFactor});
                warnedDcs.add(dcName);
            }
            result.putAll((Object)ring.get(i), replicas);
        }
        return result.build();
    }

    private boolean allDone(Map<String, Set<Node>> map, Map<String, Integer> dcNodeCount) {
        for (Map.Entry<String, Set<Node>> entry : map.entrySet()) {
            int dcCount;
            String dc = entry.getKey();
            int n = dcCount = dcNodeCount.get(dc) == null ? 0 : dcNodeCount.get(dc);
            if (entry.getValue().size() >= Math.min(this.replicationFactors.get(dc), dcCount)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Set<String>> getRacksInDcs(Iterable<Node> nodes) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Node node : nodes) {
            Set racks = result.computeIfAbsent(node.getDatacenter(), k -> new HashSet());
            racks.add(node.getRack());
        }
        return result;
    }

    private static Token getTokenWrapping(int i, List<Token> ring) {
        return ring.get(i % ring.size());
    }
}

