/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;

@Immutable
public class DefaultNodeInfo
implements NodeInfo {
    private final EndPoint endPoint;
    private final InetSocketAddress broadcastRpcAddress;
    private final InetSocketAddress broadcastAddress;
    private final InetSocketAddress listenAddress;
    private final String datacenter;
    private final String rack;
    private final String cassandraVersion;
    private final String partitioner;
    private final Set<String> tokens;
    private final Map<String, Object> extras;
    private final UUID hostId;
    private final UUID schemaVersion;

    public static Builder builder() {
        return new Builder();
    }

    private DefaultNodeInfo(Builder builder) {
        this.endPoint = builder.endPoint;
        this.broadcastRpcAddress = builder.broadcastRpcAddress;
        this.broadcastAddress = builder.broadcastAddress;
        this.listenAddress = builder.listenAddress;
        this.datacenter = builder.datacenter;
        this.rack = builder.rack;
        this.cassandraVersion = builder.cassandraVersion;
        this.partitioner = builder.partitioner;
        this.tokens = builder.tokens == null ? Collections.emptySet() : builder.tokens;
        this.hostId = builder.hostId;
        this.schemaVersion = builder.schemaVersion;
        this.extras = builder.extras == null ? Collections.emptyMap() : builder.extras;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    public Optional<InetSocketAddress> getBroadcastRpcAddress() {
        return Optional.ofNullable(this.broadcastRpcAddress);
    }

    @Override
    public Optional<InetSocketAddress> getBroadcastAddress() {
        return Optional.ofNullable(this.broadcastAddress);
    }

    @Override
    public Optional<InetSocketAddress> getListenAddress() {
        return Optional.ofNullable(this.listenAddress);
    }

    @Override
    public String getDatacenter() {
        return this.datacenter;
    }

    @Override
    public String getRack() {
        return this.rack;
    }

    @Override
    public String getCassandraVersion() {
        return this.cassandraVersion;
    }

    @Override
    public String getPartitioner() {
        return this.partitioner;
    }

    @Override
    public Set<String> getTokens() {
        return this.tokens;
    }

    @Override
    public Map<String, Object> getExtras() {
        return this.extras;
    }

    @Override
    public UUID getHostId() {
        return this.hostId;
    }

    @Override
    public UUID getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotThreadSafe
    public static class Builder {
        private EndPoint endPoint;
        private InetSocketAddress broadcastRpcAddress;
        private InetSocketAddress broadcastAddress;
        private InetSocketAddress listenAddress;
        private String datacenter;
        private String rack;
        private String cassandraVersion;
        private String partitioner;
        private Set<String> tokens;
        private Map<String, Object> extras;
        private UUID hostId;
        private UUID schemaVersion;

        public Builder withEndPoint(EndPoint endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public Builder withBroadcastRpcAddress(InetSocketAddress address) {
            this.broadcastRpcAddress = address;
            return this;
        }

        public Builder withBroadcastAddress(InetSocketAddress address) {
            this.broadcastAddress = address;
            return this;
        }

        public Builder withListenAddress(InetSocketAddress address) {
            this.listenAddress = address;
            return this;
        }

        public Builder withDatacenter(String datacenter) {
            this.datacenter = datacenter;
            return this;
        }

        public Builder withRack(String rack) {
            this.rack = rack;
            return this;
        }

        public Builder withCassandraVersion(String cassandraVersion) {
            this.cassandraVersion = cassandraVersion;
            return this;
        }

        public Builder withPartitioner(String partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public Builder withTokens(Set<String> tokens) {
            this.tokens = tokens;
            return this;
        }

        public Builder withHostId(UUID hostId) {
            this.hostId = hostId;
            return this;
        }

        public Builder withSchemaVersion(UUID schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder withExtra(String key, Object value) {
            if (value != null) {
                if (this.extras == null) {
                    this.extras = new HashMap<String, Object>();
                }
                this.extras.put(key, value);
            }
            return this;
        }

        public DefaultNodeInfo build() {
            return new DefaultNodeInfo(this);
        }
    }
}

