/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class DefaultEndPoint
implements EndPoint {
    private final InetSocketAddress address;
    private final String metricPrefix;

    public DefaultEndPoint(InetSocketAddress address) {
        Preconditions.checkNotNull((Object)address);
        this.address = address;
        this.metricPrefix = DefaultEndPoint.buildMetricPrefix(address);
    }

    @Override
    public InetSocketAddress resolve() {
        return this.address;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DefaultEndPoint) {
            DefaultEndPoint that = (DefaultEndPoint)other;
            return this.address.equals(that.address);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public String toString() {
        return this.address.toString();
    }

    @Override
    public String asMetricPrefix() {
        return this.metricPrefix;
    }

    private static String buildMetricPrefix(InetSocketAddress addressAndPort) {
        StringBuilder prefix = new StringBuilder();
        InetAddress address = addressAndPort.getAddress();
        int port = addressAndPort.getPort();
        if (address instanceof Inet4Address) {
            prefix.append(address.getHostAddress().replace('.', '_'));
        } else {
            assert (address instanceof Inet6Address);
            prefix.append(address.getHostAddress());
        }
        return prefix.append(':').append(port).toString();
    }
}

