/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.net.SocketAddress;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public abstract class ConnectInitHandler
extends ChannelDuplexHandler {
    private ChannelPromise initPromise;
    private ChannelHandlerContext ctx;

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise callerPromise) throws Exception {
        this.ctx = ctx;
        this.initPromise = ctx.channel().newPromise();
        ChannelPromise realConnectPromise = ctx.channel().newPromise();
        super.connect(ctx, remoteAddress, localAddress, realConnectPromise);
        realConnectPromise.addListener(future -> this.onRealConnect(ctx));
        PromiseCombiner combiner = new PromiseCombiner();
        combiner.addAll(new Future[]{realConnectPromise, this.initPromise});
        combiner.finish((Promise)callerPromise);
    }

    protected abstract void onRealConnect(ChannelHandlerContext var1);

    protected boolean setConnectSuccess() {
        boolean result = this.initPromise.trySuccess();
        if (result) {
            this.ctx.pipeline().remove((ChannelHandler)this);
        }
        return result;
    }

    protected void setConnectFailure(Throwable cause) {
        if (this.initPromise.tryFailure(cause)) {
            this.ctx.channel().close();
        }
    }
}

