/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.auth;

import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.auth.Authenticator;
import com.datastax.oss.driver.api.core.auth.SyncAuthenticator;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PlainTextAuthProvider
implements AuthProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PlainTextAuthProvider.class);
    private final String logPrefix;
    private final DriverExecutionProfile config;

    public PlainTextAuthProvider(DriverContext context) {
        this.logPrefix = context.getSessionName();
        this.config = context.getConfig().getDefaultProfile();
    }

    @Override
    @NonNull
    public Authenticator newAuthenticator(@NonNull EndPoint endPoint, @NonNull String serverAuthenticator) {
        String username = this.config.getString(DefaultDriverOption.AUTH_PROVIDER_USER_NAME);
        String password = this.config.getString(DefaultDriverOption.AUTH_PROVIDER_PASSWORD);
        return new PlainTextAuthenticator(username, password);
    }

    @Override
    public void onMissingChallenge(@NonNull EndPoint endPoint) {
        LOG.warn("[{}] {} did not send an authentication challenge; This is suspicious because the driver expects authentication", (Object)this.logPrefix, (Object)endPoint);
    }

    @Override
    public void close() throws Exception {
    }

    private static class PlainTextAuthenticator
    implements SyncAuthenticator {
        private final ByteBuffer initialToken;

        PlainTextAuthenticator(String username, String password) {
            byte[] usernameBytes = username.getBytes(Charsets.UTF_8);
            byte[] passwordBytes = password.getBytes(Charsets.UTF_8);
            this.initialToken = ByteBuffer.allocate(usernameBytes.length + passwordBytes.length + 2);
            this.initialToken.put((byte)0);
            this.initialToken.put(usernameBytes);
            this.initialToken.put((byte)0);
            this.initialToken.put(passwordBytes);
            this.initialToken.flip();
        }

        @Override
        public ByteBuffer initialResponseSync() {
            return this.initialToken.duplicate();
        }

        @Override
        public ByteBuffer evaluateChallengeSync(ByteBuffer token) {
            return null;
        }

        @Override
        public void onAuthenticationSuccessSync(ByteBuffer token) {
        }
    }
}

