/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.shaded.guava.common.collect.AbstractIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class PagingIterableWrapper<SourceT, TargetT>
implements PagingIterable<TargetT> {
    private final PagingIterable<SourceT> source;
    private final Iterator<TargetT> iterator;

    public PagingIterableWrapper(PagingIterable<SourceT> source, final Function<? super SourceT, ? extends TargetT> elementMapper) {
        this.source = source;
        final Iterator sourceIterator = source.iterator();
        this.iterator = new AbstractIterator<TargetT>(){

            protected TargetT computeNext() {
                return sourceIterator.hasNext() ? elementMapper.apply(sourceIterator.next()) : this.endOfData();
            }
        };
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.source.getColumnDefinitions();
    }

    @Override
    @NonNull
    public List<ExecutionInfo> getExecutionInfos() {
        return this.source.getExecutionInfos();
    }

    @Override
    public boolean isFullyFetched() {
        return this.source.isFullyFetched();
    }

    @Override
    public int getAvailableWithoutFetching() {
        return this.source.getAvailableWithoutFetching();
    }

    @Override
    public boolean wasApplied() {
        return this.source.wasApplied();
    }

    @Override
    public Iterator<TargetT> iterator() {
        return this.iterator;
    }
}

