/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.Bindable;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.internal.core.time.ServerSideTimestampGenerator;
import com.datastax.oss.driver.internal.core.util.Sizes;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.query.Values;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.List;

public interface BoundStatement
extends BatchableStatement<BoundStatement>,
Bindable<BoundStatement> {
    @NonNull
    public PreparedStatement getPreparedStatement();

    @NonNull
    public List<ByteBuffer> getValues();

    @Override
    @Nullable
    default public CqlIdentifier getKeyspace() {
        return null;
    }

    @Override
    default public int computeSizeInBytes(@NonNull DriverContext context) {
        int size = Sizes.minimumStatementSize(this, context);
        size += PrimitiveSizes.sizeOfShortBytes((byte[])this.getPreparedStatement().getId().array());
        if (this.getPreparedStatement().getResultMetadataId() != null) {
            size += PrimitiveSizes.sizeOfShortBytes((byte[])this.getPreparedStatement().getResultMetadataId().array());
        }
        size += Values.sizeOfPositionalValues(this.getValues());
        size += 4;
        if (this.getPagingState() != null) {
            size += PrimitiveSizes.sizeOfBytes((ByteBuffer)this.getPagingState());
        }
        if (!(context.getTimestampGenerator() instanceof ServerSideTimestampGenerator) || this.getQueryTimestamp() != Long.MIN_VALUE) {
            size += 8;
        }
        return size;
    }
}

