/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.NoNodeAvailableException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;

public class AllNodesFailedException
extends DriverException {
    private final Map<Node, Throwable> errors;

    @NonNull
    public static AllNodesFailedException fromErrors(@Nullable Map<Node, Throwable> errors) {
        if (errors == null || errors.isEmpty()) {
            return new NoNodeAvailableException();
        }
        return new AllNodesFailedException((Map<Node, Throwable>)ImmutableMap.copyOf(errors));
    }

    @NonNull
    public static AllNodesFailedException fromErrors(@Nullable List<Map.Entry<Node, Throwable>> errors) {
        ImmutableMap map;
        if (errors == null || errors.isEmpty()) {
            map = null;
        } else {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<Node, Throwable> entry : errors) {
                builder.put(entry);
            }
            map = builder.build();
        }
        return AllNodesFailedException.fromErrors(map);
    }

    protected AllNodesFailedException(@NonNull String message, @Nullable ExecutionInfo executionInfo, @NonNull Map<Node, Throwable> errors) {
        super(message, executionInfo, null, true);
        this.errors = errors;
    }

    private AllNodesFailedException(Map<Node, Throwable> errors) {
        this(AllNodesFailedException.buildMessage(String.format("All %d node(s) tried for the query failed", errors.size()), errors), null, errors);
    }

    private static String buildMessage(String baseMessage, Map<Node, Throwable> errors) {
        int limit = Math.min(errors.size(), 3);
        String details = Joiner.on((String)", ").withKeyValueSeparator(": ").join(Iterables.limit(errors.entrySet(), (int)limit));
        return String.format(baseMessage + " (showing first %d, use getErrors() for more: %s)", limit, details);
    }

    @NonNull
    public Map<Node, Throwable> getErrors() {
        return this.errors;
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new AllNodesFailedException(this.getMessage(), this.getExecutionInfo(), this.errors);
    }

    @NonNull
    public AllNodesFailedException reword(String newMessage) {
        return new AllNodesFailedException(AllNodesFailedException.buildMessage(newMessage, this.errors), this.getExecutionInfo(), this.errors);
    }
}

