/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;

class PooledConnection
extends Connection {
    final HostConnectionPool pool;
    final AtomicBoolean markForTrash = new AtomicBoolean();

    PooledConnection(String name, InetSocketAddress address, Connection.Factory factory, HostConnectionPool pool) throws ConnectionException, InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
        super(name, address, factory);
        this.pool = pool;
    }

    public void release() {
        if (this.pool == null) {
            return;
        }
        this.pool.returnConnection(this);
    }

    @Override
    protected void notifyOwnerWhenDefunct(boolean hostIsDown) {
        if (this.pool == null) {
            return;
        }
        if (hostIsDown) {
            this.pool.closeAsync().force();
        } else {
            this.pool.replaceDefunctConnection(this);
        }
    }
}

